/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.api.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import org.apache.commons.lang3.Validate;

public class Digests {
    private static final String SHA1 = "SHA-1";
    private static final String MD5 = "MD5";
    private static SecureRandom random = new SecureRandom();

    public static byte[] md5(byte[] input) {
        return Digests.digest(input, MD5, null, 1);
    }

    public static byte[] md5(byte[] input, int iterations) {
        return Digests.digest(input, MD5, null, iterations);
    }

    public static byte[] sha1(byte[] input) {
        return Digests.digest(input, SHA1, null, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt) {
        return Digests.digest(input, SHA1, salt, 1);
    }

    public static byte[] sha1(byte[] input, byte[] salt, int iterations) {
        return Digests.digest(input, SHA1, salt, iterations);
    }

    private static byte[] digest(byte[] input, String algorithm, byte[] salt, int iterations) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            if (salt != null) {
                digest.update(salt);
            }
            byte[] result = digest.digest(input);
            int i = 1;
            while (i < iterations) {
                digest.reset();
                result = digest.digest(result);
                ++i;
            }
            return result;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateSalt(int numBytes) {
        Validate.isTrue((numBytes > 0 ? 1 : 0) != 0, (String)"numBytes argument must be a positive integer (1 or larger)", (long)numBytes);
        byte[] bytes = new byte[numBytes];
        random.nextBytes(bytes);
        return bytes;
    }

    public static byte[] md5(InputStream input) throws IOException {
        return Digests.digest(input, MD5);
    }

    public static byte[] sha1(InputStream input) throws IOException {
        return Digests.digest(input, SHA1);
    }

    private static byte[] digest(InputStream input, String algorithm) throws IOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
            int bufferLength = 8192;
            byte[] buffer = new byte[bufferLength];
            int read = input.read(buffer, 0, bufferLength);
            while (read > -1) {
                messageDigest.update(buffer, 0, read);
                read = input.read(buffer, 0, bufferLength);
            }
            return messageDigest.digest();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static final String md5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            MessageDigest mdTemp = MessageDigest.getInstance(MD5);
            try {
                mdTemp.update(s.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                mdTemp.update(s.getBytes());
            }
            byte[] md = mdTemp.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            int i = 0;
            while (i < j) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            return new String(str).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final String buildToken(String url, String paramJson, String secret) {
        int index;
        String tempUrl = null;
        tempUrl = url.contains("https://") ? url.substring("https://".length()) : url.substring("http://".length());
        String URI = tempUrl.substring(index = tempUrl.indexOf("/"));
        String[] ss = URI.split("\\?");
        if (ss.length > 1) {
            return Digests.md5(String.valueOf(ss[0]) + ss[1] + secret);
        }
        return Digests.md5(String.valueOf(ss[0]) + paramJson + secret);
    }

    public static void main(String[] args) {
        System.out.println(Digests.md5("abc"));
    }
}

