/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.protocol.gx.MsgAppReset;
import com.gg.reader.api.protocol.gx.MsgUpgradeApp;
import com.gg.reader.api.protocol.gx.MsgUpgradeBaseband;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;

public class UpgradeUtils {
    public static void upgradeBase(File binFile, GClient client) throws Exception {
        if (binFile == null || !binFile.exists()) {
            throw new Exception("binFile not found!!!");
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(binFile));
        byte[] buffer = new byte[256];
        int len = -1;
        long count = 1L;
        MsgUpgradeBaseband msg = new MsgUpgradeBaseband();
        msg.setPacketNumber(0L);
        client.sendSynMsg(msg);
        if (msg.getRtCode() != 0) {
            client.sendSynMsg(msg);
        }
        if (msg.getRtCode() == 0) {
            while ((len = bis.read(buffer)) != -1) {
                msg.setPacketNumber(count);
                msg.setPacketContent(buffer);
                client.sendSynMsg(msg);
                if (msg.getRtCode() == 0 && msg.getPacketNumber() == count) {
                    msg.setRtCode((byte)-1);
                    ++count;
                    continue;
                }
                throw new Exception("upgrade Failure");
            }
            msg.setPacketNumber(Long.parseLong("FFFFFFFF", 16));
            msg.setPacketContent(null);
            client.sendSynMsg(msg);
            if (msg.getRtCode() != 0) {
                throw new Exception("upgrade Failure");
            }
        } else {
            throw new Exception("upgrade Failure");
        }
        Thread.sleep(2000L);
        client.sendSynMsg(new MsgAppReset());
        bis.close();
    }

    public static void upgradeApp(File appFile, GClient client) throws Exception {
        if (appFile == null || !appFile.exists()) {
            throw new Exception("binFile not found!!!");
        }
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(appFile));
        byte[] buffer = new byte[512];
        int len = -1;
        long count = 1L;
        MsgUpgradeApp msg = new MsgUpgradeApp();
        msg.setPacketNumber(0L);
        client.sendSynMsg(msg);
        if (msg.getRtCode() != 0) {
            client.sendSynMsg(msg);
        }
        if (msg.getRtCode() == 0) {
            while ((len = bis.read(buffer)) != -1) {
                msg.setPacketNumber(count);
                msg.setPacketContent(buffer);
                client.sendSynMsg(msg);
                if (msg.getRtCode() != 0 || msg.getPacketNumber() != count) {
                    throw new Exception("upgrade Failure");
                }
                msg.setRtCode((byte)-1);
                System.out.println(++count);
            }
            msg.setPacketNumber(Long.parseLong("FFFFFFFF", 16));
            msg.setPacketContent(null);
            client.sendSynMsg(msg);
            if (msg.getRtCode() != 0) {
                throw new Exception("upgrade Failure");
            }
        } else {
            throw new Exception("upgrade Failure");
        }
        Thread.sleep(5000L);
        client.sendSynMsg(new MsgAppReset());
        bis.close();
    }

    public static void main(String[] args) {
        GClient client = new GClient();
        File file = new File("D:/xxx.apk");
        try {
            UpgradeUtils.upgradeApp(file, client);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

