/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;

public class MsgType {
    public byte msgId = (byte)-1;
    public String mt_8_11 = "0000";
    public String mt_12 = "0";
    public String mt_13 = "0";
    public String mt_14 = "0";
    public String mt_15 = "0";
    public byte pVersion = 1;
    public byte pType = 0;

    public MsgType() {
    }

    public MsgType(byte mid, String mt_8_11, String mt_12, String mt_13) {
        this.msgId = mid;
        this.mt_8_11 = mt_8_11;
        this.mt_12 = mt_12;
        this.mt_13 = mt_13;
    }

    public MsgType(byte[] data) {
        try {
            this.msgId = data[3];
            String sMsgType = this.byte2bits(data[2]);
            sMsgType = StringUtils.padRight(sMsgType, '0', 8);
            this.mt_8_11 = sMsgType.substring(4, 8);
            this.mt_12 = sMsgType.substring(3, 4);
            this.mt_13 = sMsgType.substring(2, 3);
            this.mt_14 = sMsgType.substring(1, 2);
            this.mt_15 = sMsgType.substring(0, 1);
            this.pVersion = data[1];
            this.pType = data[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] toBytes() {
        byte[] rt = new byte[4];
        try {
            String sMsgType = this.mt_15 + this.mt_14 + this.mt_13 + this.mt_12 + this.mt_8_11;
            byte bMsgType = MsgType.bit2byte(sMsgType);
            rt[3] = this.msgId;
            rt[2] = bMsgType;
            rt[1] = this.pVersion;
            rt[0] = this.pType;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rt;
    }

    public int toInt() {
        byte[] bData = this.toBytes();
        BitBuffer buffer = BitBuffer.wrap(bData);
        buffer.position(0);
        int rt = buffer.getIntUnsigned(32);
        return rt;
    }

    private String byte2bits(byte b) {
        int z = b;
        String str = Integer.toBinaryString(z |= 0x100);
        int len = str.length();
        return str.substring(len - 8, len);
    }

    public static byte bit2byte(String bString) {
        byte result = 0;
        int i = bString.length() - 1;
        int j = 0;
        while (i >= 0) {
            result = (byte)((double)result + (double)Byte.parseByte(bString.charAt(i) + "") * Math.pow(2.0, j));
            --i;
            ++j;
        }
        return result;
    }
}

