/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgAppSetEthernetIP
extends Message {
    private int autoIp;
    private String iP = "0.0.0.0";
    private String mask = "0.0.0.0";
    private String gateway = "0.0.0.0";
    private String dns1 = "0.0.0.0";
    private String dns2 = "0.0.0.0";

    public MsgAppSetEthernetIP() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)4;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetEthernetIP(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.autoIp = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.iP = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                        break;
                    }
                    case 2: {
                        this.mask = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        this.gateway = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                        break;
                    }
                    case 4: {
                        this.dns1 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                        break;
                    }
                    case 5: {
                        this.dns2 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAutoIp() {
        return this.autoIp;
    }

    public void setAutoIp(int autoIp) {
        this.autoIp = autoIp;
    }

    public String getiP() {
        return this.iP;
    }

    public void setiP(String iP) {
        this.iP = iP;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getDns1() {
        return this.dns1;
    }

    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    public String getDns2() {
        return this.dns2;
    }

    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.autoIp, 8);
        if (1 == this.autoIp) {
            String[] dns2s;
            String[] dns1s;
            String[] gateways;
            String[] masks;
            String[] iPs;
            buffer.putInt(1, 8);
            for (String i : iPs = this.iP.split("\\.")) {
                buffer.putInt(Integer.parseInt(i), 8);
            }
            buffer.putInt(2, 8);
            for (String m : masks = this.mask.split("\\.")) {
                buffer.putInt(Integer.parseInt(m), 8);
            }
            buffer.putInt(3, 8);
            for (String g : gateways = this.gateway.split("\\.")) {
                buffer.putInt(Integer.parseInt(g), 8);
            }
            buffer.putInt(4, 8);
            for (String d1 : dns1s = this.dns1.split("\\.")) {
                buffer.putInt(Integer.parseInt(d1), 8);
            }
            buffer.putInt(5, 8);
            for (String d2 : dns2s = this.dns2.split("\\.")) {
                buffer.putInt(Integer.parseInt(d2), 8);
            }
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "ReaderIp parameter error .");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

