/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetTcpMode
extends Message {
    private int tcpMode;
    private int serverPort = Integer.MAX_VALUE;
    private String clientIp;
    private int clientPort = Integer.MAX_VALUE;

    public MsgAppGetTcpMode() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)8;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetTcpMode(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.tcpMode = buffer.getIntUnsigned(8);
            this.serverPort = buffer.getIntUnsigned(16);
            this.clientIp = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.clientPort = buffer.getIntUnsigned(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getTcpMode() {
        return this.tcpMode;
    }

    public void setTcpMode(int tcpMode) {
        this.tcpMode = tcpMode;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.tcpMode, 8);
            if (Integer.MAX_VALUE != this.serverPort) {
                buffer.put(this.serverPort, 16);
            }
            if (null != this.clientIp) {
                String[] iPs;
                for (String i : iPs = this.clientIp.split("\\.")) {
                    buffer.put(Integer.parseInt(i), 8);
                }
            }
            if (Integer.MAX_VALUE != this.clientPort) {
                buffer.put(this.clientPort, 16);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.tcpMode = buffer.getIntUnsigned(8);
            this.serverPort = buffer.getIntUnsigned(16);
            this.clientIp = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.clientPort = buffer.getIntUnsigned(16);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetTcpMode{tcpMode=" + this.tcpMode + ", serverPort=" + this.serverPort + ", clientIp='" + this.clientIp + '\'' + ", clientPort=" + this.clientPort + '}';
    }
}

