/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.net.Socket;
import java.util.Arrays;
import org.hid4java.HidDevice;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.event.HidServicesEvent;

public class UsbHidClient
extends CommunicationInterface
implements HidServicesListener {
    private Integer VENDOR_ID = 1003;
    private Integer PRODUCT_ID = 9249;
    private int PACKET_LENGTH = 64;
    private String SERIAL_NUMBER = "123123123123";
    private String KBD = "kbd";
    private HidServices hidServices;
    private HidDevice hidDevice;
    private boolean isClose = false;

    @Override
    public void hidDeviceAttached(HidServicesEvent event) {
    }

    @Override
    public void hidDeviceDetached(HidServicesEvent event) {
        if (this.onUsbHidRemoved != null) {
            this.onUsbHidRemoved.hidDeviceDetached(event);
        }
    }

    @Override
    public void hidFailure(HidServicesEvent event) {
    }

    private void sendMessage(HidDevice hidDevice) {
        if (!hidDevice.isOpen()) {
            hidDevice.open();
        }
        byte[] message = new byte[this.PACKET_LENGTH];
        message[0] = 63;
        message[1] = 35;
        message[2] = 35;
        message[3] = 0;
        int val = 0;
        val = hidDevice.write(message, this.PACKET_LENGTH, (byte)0);
        if (val >= 0) {
            System.out.println("> [" + val + "]");
        } else {
            System.err.println(hidDevice.getLastErrorMessage());
        }
        boolean moreData = true;
        while (moreData) {
            byte[] data = new byte[this.PACKET_LENGTH];
            val = hidDevice.read(data, 500);
            switch (val) {
                case -1: {
                    GLog.e(hidDevice.getLastErrorMessage());
                    break;
                }
                case 0: {
                    moreData = false;
                    break;
                }
            }
        }
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        return false;
    }

    @Override
    public boolean open(HidDevice hidDevice) {
        try {
            if (hidDevice == null) {
                return false;
            }
            if (hidDevice.getVendorId() == this.VENDOR_ID.intValue() && hidDevice.getProductId() == this.PRODUCT_ID.intValue() && !hidDevice.getPath().endsWith(this.KBD) && !hidDevice.isOpen()) {
                this.hidDevice = hidDevice;
                if (this.hidDevice.open()) {
                    this.keepReceived = true;
                    this.startReceive();
                    this.startProcess();
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.isClose = true;
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notify();
                this.ringBuffer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        Class<UsbHidClient> clazz = UsbHidClient.class;
        synchronized (UsbHidClient.class) {
            try {
                int dataLen = data.length;
                int size = dataLen / 64;
                if (dataLen % 64 != 0) {
                    ++size;
                }
                for (int i = 0; i < size; ++i) {
                    byte[] newBuffer = Arrays.copyOfRange(data, i * 64, 64 + i * 64);
                    int n = this.hidDevice.write(newBuffer, this.PACKET_LENGTH, (byte)0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message msg) {
        Class<UsbHidClient> clazz = UsbHidClient.class;
        synchronized (UsbHidClient.class) {
            try {
                if (this.isRs485) {
                    msg.msgType.mt_13 = "1";
                    msg.rs485Address = this.getRs485Address();
                }
                msg.pack();
                byte[] sendData = msg.toBytes(this.isRs485);
                this.send(sendData);
            }
            catch (Exception ex) {
                GLog.e("[UsbHidClient]send error:" + ex.getMessage());
            }
            return;
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (UsbHidClient.this.keepReceived) {
                    if (UsbHidClient.this.isClose) {
                        UsbHidClient.this.isClose = false;
                        UsbHidClient.this.keepReceived = false;
                        if (UsbHidClient.this.hidDevice != null) {
                            UsbHidClient.this.hidDevice.close();
                        }
                    }
                    try {
                        byte[] bytes = new byte[UsbHidClient.this.PACKET_LENGTH];
                        int ret = UsbHidClient.this.hidDevice.read(bytes, 100);
                        if (ret <= 0) continue;
                        Object object = UsbHidClient.this.lockRingBuffer;
                        synchronized (object) {
                            while (ret + UsbHidClient.this.ringBuffer.getDataCount() > 0x100000) {
                                UsbHidClient.this.lockRingBuffer.wait(10000L);
                            }
                            UsbHidClient.this.ringBuffer.WriteBuffer(bytes, 0, ret);
                            UsbHidClient.this.lockRingBuffer.notify();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

