/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal;

import com.gg.reader.api.dal.GClient;
import com.gg.reader.api.dal.HandlerGClientConnected;
import com.gg.reader.api.dal.HandlerRemoteConnected;
import com.gg.reader.api.dal.communication.TcpClient;
import com.gg.reader.api.dal.communication.TcpServer;
import com.gg.reader.api.protocol.gx.MsgAppGetReaderInfo;
import com.gg.reader.api.protocol.gx.MsgTestWorkModeInit;
import com.gg.reader.api.utils.StringUtils;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.util.HashMap;
import java.util.Map;

public class GServer {
    private TcpServer ts;
    private int MSG_TIME_OUT = 3000;
    public HandlerGClientConnected onGClientConnected;
    private String initParam;
    private HashMap<String, GClient> hpClient = new HashMap();

    public boolean isListener() {
        if (null == this.ts) {
            return false;
        }
        return this.ts.keepListen;
    }

    public String getInitParam() {
        return this.initParam;
    }

    public HashMap<String, GClient> getHpClient() {
        return this.hpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGClientConnectedEvent(GClient client, String serialNumber) {
        block5: {
            try {
                if (this.onGClientConnected == null) break block5;
                HandlerGClientConnected handlerGClientConnected = this.onGClientConnected;
                synchronized (handlerGClientConnected) {
                    this.onGClientConnected.log(client, serialNumber);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean open(int param) {
        if (null != this.ts) {
            return false;
        }
        this.ts = new TcpServer();
        this.ts.onRemoteConnected = new HandlerRemoteConnected(){

            @Override
            public void log(TcpClient client) {
                GServer.this.processConnect(client);
            }
        };
        if (!this.ts.open(param)) {
            this.close();
            return false;
        }
        return true;
    }

    public boolean open(int param, String initParam) {
        this.initParam = initParam;
        return this.open(param);
    }

    public void close() {
        if (null != this.ts) {
            this.ts.close();
            this.ts = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeClient(String readerSerialNumber) {
        if (readerSerialNumber == null || readerSerialNumber == "") {
            return;
        }
        String[] arrName = readerSerialNumber.split(":");
        if (null != arrName && arrName.length == 2) {
            HashMap<String, GClient> hashMap = this.hpClient;
            synchronized (hashMap) {
                if (this.hpClient.containsKey(readerSerialNumber)) {
                    this.hpClient.get(readerSerialNumber).close();
                    this.hpClient.remove(readerSerialNumber);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllClient() {
        HashMap<String, GClient> hashMap = this.hpClient;
        synchronized (hashMap) {
            for (Map.Entry<String, GClient> item : this.hpClient.entrySet()) {
                item.getValue().close();
            }
            this.hpClient.clear();
        }
    }

    public void processConnect(final TcpClient client) {
        if (null == client) {
            return;
        }
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GClient gClient = new GClient();
                String readerName = client.serverIp + ":" + client.serverPort;
                if (gClient.open(readerName, client, GServer.this.MSG_TIME_OUT)) {
                    gClient.setName(readerName);
                    MsgAppGetReaderInfo info = new MsgAppGetReaderInfo();
                    gClient.sendSynMsg(info);
                    if (info.getRtCode() != 0) {
                        gClient.close();
                        client.close();
                        return;
                    }
                    if (StringUtils.isNullOfEmpty(info.getReaderSerialNumber())) {
                        gClient.close();
                        client.close();
                        return;
                    }
                    if (!StringUtils.isNullOfEmpty(GServer.this.initParam)) {
                        gClient.sendUnsynMsg(new MsgTestWorkModeInit(GServer.this.initParam, 0));
                        gClient.setInitParam(GServer.this.initParam);
                    }
                    gClient.setSerialNumber(info.getReaderSerialNumber());
                    GServer.this.triggerGClientConnectedEvent(gClient, info.getReaderSerialNumber());
                    HashMap hashMap = GServer.this.hpClient;
                    synchronized (hashMap) {
                        if (GServer.this.hpClient.containsKey(info.getReaderSerialNumber())) {
                            ((GClient)GServer.this.hpClient.get(info.getReaderSerialNumber())).close();
                        }
                        GServer.this.hpClient.put(info.getReaderSerialNumber(), gClient);
                    }
                } else {
                    gClient.close();
                    client.close();
                }
            }
        });
    }
}

