/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.HashMap;

public class MsgTestAutoCalibrationOperate
extends Message {
    private int frequencyRange = Integer.MAX_VALUE;
    private int calibrationBase = Integer.MAX_VALUE;
    private int adjustValue = Integer.MAX_VALUE;
    private int slopeValue = Integer.MAX_VALUE;
    private int originalSlopeValue = Integer.MAX_VALUE;

    public MsgTestAutoCalibrationOperate() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)12;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getFrequencyRange() {
        return this.frequencyRange;
    }

    public int getCalibrationBase() {
        return this.calibrationBase;
    }

    public int getAdjustValue() {
        return this.adjustValue;
    }

    public int getSlopeValue() {
        return this.slopeValue;
    }

    public int getOriginalSlopeValue() {
        return this.originalSlopeValue;
    }

    public void setOriginalSlopeValue(int originalSlopeValue) {
        this.originalSlopeValue = originalSlopeValue;
    }

    public void buildSetCalibrateBase(int frequencyRange, int calibrationBase) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(1, 8);
        buffer.putInt(frequencyRange, 8);
        buffer.putInt(calibrationBase, 16);
        this.cData = buffer.asByteArray();
    }

    public void buildGetCalibrateBase(int frequencyRange) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(2, 8);
        buffer.putInt(frequencyRange, 8);
        this.cData = buffer.asByteArray();
    }

    public void buildSetCalibrationBaseAdjustValue(int adjustValue) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(3, 8);
        buffer.putInt(adjustValue, 16);
        this.cData = buffer.asByteArray();
    }

    public void buildGetCalibrationBaseAdjustValue() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(4, 8);
        this.cData = buffer.asByteArray();
    }

    public void buildSetSlopeValue(int slopeValue) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(5, 8);
        buffer.putInt(slopeValue, 8);
        this.cData = buffer.asByteArray();
    }

    public void buildGetSlopeValue() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(6, 8);
        this.cData = buffer.asByteArray();
    }

    public void buildSetOriginalSlopeValue(int slopeValue) {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(7, 8);
        buffer.putInt(slopeValue, 8);
        this.cData = buffer.asByteArray();
    }

    public void buildGetOriginalSlopeValue() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(8, 8);
        this.cData = buffer.asByteArray();
    }

    @Override
    public void pack() {
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        HashMap<Byte, String> dicErrorMsg = new HashMap<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Failure.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            int pid = buffer.getIntUnsigned(8);
            switch (pid) {
                case 1: 
                case 3: 
                case 5: 
                case 7: {
                    byte code = (byte)buffer.getIntUnsigned(8);
                    this.setRtCode(code);
                    if (!dicErrorMsg.containsKey(code)) break;
                    this.setRtMsg((String)dicErrorMsg.get(code));
                    break;
                }
                case 2: {
                    this.setRtCode((byte)0);
                    this.calibrationBase = buffer.getIntUnsigned(16);
                    break;
                }
                case 4: {
                    this.setRtCode((byte)0);
                    this.adjustValue = buffer.getInt(16);
                    break;
                }
                case 6: {
                    this.setRtCode((byte)0);
                    this.slopeValue = buffer.getIntUnsigned(8);
                }
                case 8: {
                    this.setRtCode((byte)0);
                    this.originalSlopeValue = buffer.getIntUnsigned(8);
                }
            }
        }
    }
}

