/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetEthernetIP
extends Message {
    private int autoIp;
    private String iP;
    private String mask;
    private String gateway;
    private String dns1;
    private String dns2;

    public MsgAppGetEthernetIP() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)5;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetEthernetIP(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.autoIp = buffer.getIntUnsigned(8);
            this.iP = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.mask = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.gateway = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.dns1 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.dns2 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAutoIp() {
        return this.autoIp;
    }

    public void setAutoIp(int autoIp) {
        this.autoIp = autoIp;
    }

    public String getiP() {
        return this.iP;
    }

    public void setiP(String iP) {
        this.iP = iP;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    public String getDns1() {
        return this.dns1;
    }

    public void setDns1(String dns1) {
        this.dns1 = dns1;
    }

    public String getDns2() {
        return this.dns2;
    }

    public void setDns2(String dns2) {
        this.dns2 = dns2;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.autoIp, 8);
            if (this.iP != null) {
                String[] iPs;
                for (String i : iPs = this.iP.split("\\.")) {
                    buffer.putInt(Integer.parseInt(i), 8);
                }
            }
            if (this.mask != null) {
                String[] masks;
                for (String m : masks = this.mask.split("\\.")) {
                    buffer.putInt(Integer.parseInt(m), 8);
                }
            }
            if (this.gateway != null) {
                String[] gateways;
                for (String g : gateways = this.gateway.split("\\.")) {
                    buffer.putInt(Integer.parseInt(g), 8);
                }
            }
            if (this.dns1 != null) {
                String[] dns1s;
                for (String d1 : dns1s = this.dns1.split("\\.")) {
                    buffer.putInt(Integer.parseInt(d1), 8);
                }
            }
            if (this.dns2 != null) {
                String[] dns2s;
                for (String d2 : dns2s = this.dns2.split("\\.")) {
                    buffer.putInt(Integer.parseInt(d2), 8);
                }
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.autoIp = buffer.getIntUnsigned(8);
            this.iP = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.mask = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.gateway = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.dns1 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.dns2 = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetEthernetIP{autoIp=" + this.autoIp + ", iP='" + this.iP + '\'' + ", mask='" + this.mask + '\'' + ", gateway='" + this.gateway + '\'' + ", dns1='" + this.dns1 + '\'' + ", dns2='" + this.dns2 + '\'' + '}';
    }
}

