/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.HandlerDisconnected;
import com.gg.reader.api.dal.communication.HandlerMessageReceived;
import com.gg.reader.api.dal.communication.HandlerUsbHidRemoved;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.RingBuffer;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.net.Socket;
import org.hid4java.HidDevice;
import org.hid4java.event.HidServicesEvent;

public abstract class CommunicationInterface {
    public HandlerMessageReceived onMessageReceived;
    public HandlerDisconnected onDisconnected;
    public HandlerUsbHidRemoved onUsbHidRemoved;
    protected int connType = 255;
    protected static final int MAX_BUFFER_LEN = 0x100000;
    protected volatile RingBuffer ringBuffer = new RingBuffer(0x100000);
    protected Object lockRingBuffer = new Object();
    protected boolean keepReceived = false;
    protected byte[] rcvBuff = new byte[1024];
    protected boolean isRs485 = false;
    private int rs485Address = 0;
    public boolean _isSendHeartbeat = false;

    public boolean isRs485() {
        return this.isRs485;
    }

    public void setRs485(boolean rs485) {
        this.isRs485 = rs485;
    }

    public int getRs485Address() {
        return this.rs485Address;
    }

    public void setRs485Address(int rs485Address) {
        this.rs485Address = rs485Address;
    }

    public void setConnectType(int tt) {
        this.connType = tt;
    }

    public int getConnectType() {
        return this.connType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerMessageEvent(Message msg) {
        block5: {
            try {
                if (this.onMessageReceived == null) break block5;
                HandlerMessageReceived handlerMessageReceived = this.onMessageReceived;
                synchronized (handlerMessageReceived) {
                    this.onMessageReceived.received(msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerDisconnected() {
        block5: {
            try {
                if (this.onDisconnected == null) break block5;
                HandlerDisconnected handlerDisconnected = this.onDisconnected;
                synchronized (handlerDisconnected) {
                    this.onDisconnected.log();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerUsbHidRemoved(HidServicesEvent event) {
        block5: {
            try {
                if (this.onUsbHidRemoved == null) break block5;
                HandlerUsbHidRemoved handlerUsbHidRemoved = this.onUsbHidRemoved;
                synchronized (handlerUsbHidRemoved) {
                    this.onUsbHidRemoved.hidDeviceDetached(event);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public abstract boolean open(String var1, int var2);

    public abstract boolean open(Socket var1);

    public abstract boolean open(String var1, int var2, int var3);

    public abstract boolean open(String var1);

    public boolean open(HidDevice hidDevice) {
        return false;
    }

    public abstract void close();

    public abstract void send(byte[] var1);

    public abstract void send(Message var1);

    public abstract int receive(byte[] var1);

    public abstract boolean setBufferSize(int var1);

    public abstract void dispose();

    public void hdPowerOn() {
    }

    public void hdPowerOff() {
    }

    public void setUhfPower(boolean value) {
    }

    public boolean isConnected() {
        return this.keepReceived;
    }

    public void startProcess() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (CommunicationInterface.this.keepReceived) {
                    byte[] msgByte = null;
                    Object object = CommunicationInterface.this.lockRingBuffer;
                    synchronized (object) {
                        try {
                            if (CommunicationInterface.this.ringBuffer.getDataCount() < 7) {
                                CommunicationInterface.this.lockRingBuffer.wait();
                            }
                            if ((CommunicationInterface.this.ringBuffer.Index(0) & 0xFF) != 90) {
                                CommunicationInterface.this.ringBuffer.Clear(1);
                            } else {
                                if (CommunicationInterface.this.ringBuffer.Index(1) != 0) {
                                    CommunicationInterface.this.ringBuffer.Clear(1);
                                    continue;
                                }
                                BitBuffer buffer = BitBuffer.allocateDynamic();
                                int dataLenEndIndex = 7;
                                if (CommunicationInterface.this.isRs485) {
                                    ++dataLenEndIndex;
                                }
                                byte[] preByte = new byte[dataLenEndIndex];
                                CommunicationInterface.this.ringBuffer.ReadBuffer(preByte, 0, preByte.length);
                                buffer.put(preByte);
                                buffer.position(preByte.length * 8 - 16);
                                int dataLen = buffer.getIntUnsigned(16);
                                if (dataLen < 0 || dataLen > 1024) {
                                    CommunicationInterface.this.ringBuffer.Clear(1);
                                    continue;
                                }
                                int msgLen = dataLen + dataLenEndIndex + 2;
                                if (CommunicationInterface.this.ringBuffer.getDataCount() < msgLen) {
                                    CommunicationInterface.this.lockRingBuffer.wait();
                                    continue;
                                }
                                msgByte = new byte[msgLen];
                                CommunicationInterface.this.ringBuffer.ReadBuffer(msgByte, 0, msgLen);
                                CommunicationInterface.this.ringBuffer.Clear(msgLen);
                            }
                            if (msgByte != null) {
                                Message msg = new Message(msgByte);
                                if (msg.checkCrc()) {
                                    if (CommunicationInterface.this.isRs485 && msg.rs485Address != CommunicationInterface.this.rs485Address) {
                                        continue;
                                    }
                                    CommunicationInterface.this.triggerMessageEvent(msg);
                                } else {
                                    System.out.println("crc\u9519\u8bef" + HexUtils.bytes2HexString(msg.msgData));
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }
}

