/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamGbAntiCollision;
import com.gg.reader.api.protocol.gx.ParamGbBaseSpeed;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgBaseSetGJbBaseband
extends Message {
    private ParamGbBaseSpeed paramGbBaseSpeed;
    private ParamGbAntiCollision paramGbAntiCollision;
    private int inventoryFlag = Integer.MAX_VALUE;

    public MsgBaseSetGJbBaseband() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)-28;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseSetGJbBaseband(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(8);
                        byte[] paramData = new byte[len];
                        buffer.get(paramData);
                        this.paramGbBaseSpeed = new ParamGbBaseSpeed(paramData);
                        break;
                    }
                    case 2: {
                        int length = buffer.getIntUnsigned(8);
                        byte[] paramData = new byte[length];
                        buffer.get(paramData);
                        this.paramGbAntiCollision = new ParamGbAntiCollision(paramData);
                        break;
                    }
                    case 3: {
                        this.inventoryFlag = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ParamGbBaseSpeed getParamGbBaseSpeed() {
        return this.paramGbBaseSpeed;
    }

    public void setParamGbBaseSpeed(ParamGbBaseSpeed paramGbBaseSpeed) {
        this.paramGbBaseSpeed = paramGbBaseSpeed;
    }

    public ParamGbAntiCollision getParamGbAntiCollision() {
        return this.paramGbAntiCollision;
    }

    public void setParamGbAntiCollision(ParamGbAntiCollision paramGbAntiCollision) {
        this.paramGbAntiCollision = paramGbAntiCollision;
    }

    public int getInventoryFlag() {
        return this.inventoryFlag;
    }

    public void setInventoryFlag(int inventoryFlag) {
        this.inventoryFlag = inventoryFlag;
    }

    @Override
    public void pack() {
        byte[] tempByte;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (null != this.paramGbBaseSpeed) {
            buffer.putInt(1, 8);
            tempByte = this.paramGbBaseSpeed.toBytes();
            buffer.put(tempByte);
        }
        if (null != this.paramGbAntiCollision) {
            buffer.putInt(2, 8);
            tempByte = this.paramGbAntiCollision.toBytes();
            buffer.put(tempByte);
        }
        if (Integer.MAX_VALUE != this.inventoryFlag) {
            buffer.putInt(3, 8);
            buffer.putInt(this.inventoryFlag, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Baseband rate not support.");
                this.put((byte)2, "Session parameter error.");
                this.put((byte)3, "Inventory parameter error.");
                this.put((byte)4, "Other error.");
                this.put((byte)5, "Save failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

