/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetUdpParam
extends Message {
    private int onOrOff;
    private String ip = "0.0.0.0";
    private int port = Integer.MAX_VALUE;
    private int period = Integer.MAX_VALUE;

    public MsgAppGetUdpParam() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)40;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetUdpParam(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.onOrOff = buffer.getIntUnsigned(8);
            this.ip = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.port = buffer.getIntUnsigned(16);
            this.period = buffer.getIntUnsigned(16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getOnOrOff() {
        return this.onOrOff;
    }

    public void setOnOrOff(int onOrOff) {
        this.onOrOff = onOrOff;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putInt(this.onOrOff, 8);
            if (this.ip != null) {
                String[] iPs;
                for (String i : iPs = this.ip.split("\\.")) {
                    buffer.putInt(Integer.parseInt(i), 8);
                }
            }
            if (Integer.MAX_VALUE != this.port) {
                buffer.put(this.port, 16);
            }
            if (Integer.MAX_VALUE != this.period) {
                buffer.put(this.period, 16);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.onOrOff = buffer.getIntUnsigned(8);
            this.ip = buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8) + "." + buffer.getIntUnsigned(8);
            this.port = buffer.getIntUnsigned(16);
            this.period = buffer.getIntUnsigned(16);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetUdpParam{onOrOff=" + this.onOrOff + ", ip='" + this.ip + '\'' + ", port=" + this.port + ", period=" + this.period + '}';
    }
}

