/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

import com.gg.reader.api.utils.BitBuffer;

public abstract class SimpleBitBuffer
extends BitBuffer {
    private int position;
    protected int offset;
    protected int limit;
    protected int size;

    protected abstract byte rawGet(int var1);

    protected abstract void rawSet(int var1, byte var2);

    protected abstract int rawLength();

    protected void advance(int p, boolean write) {
        this.position += p;
        if (write && this.position > this.size) {
            this.size = this.position;
        }
    }

    @Override
    public BitBuffer putBoolean(boolean b) {
        int pos = this.offset + this.position;
        this.advance(1, true);
        this.rawSet(pos / 8, (byte)((this.rawGet(pos / 8) & ~(128 >>> pos % 8)) + ((b ? 128 : 0) >>> pos % 8)));
        return this;
    }

    @Override
    public BitBuffer putByte(byte b) {
        int pos = this.offset + this.position;
        this.advance(8, true);
        byte old = (byte)(this.rawGet(pos / 8) & (byte)(~(255 >>> pos % 8)));
        this.rawSet(pos / 8, (byte)(old | (byte)((b & 0xFF) >>> pos % 8)));
        if (pos % 8 > 0) {
            this.rawSet(pos / 8 + 1, (byte)((b & 0xFF) << 8 - pos % 8));
        }
        return this;
    }

    @Override
    public BitBuffer putByte(byte b, int bits) {
        int pos = this.offset + this.position;
        this.advance(bits, true);
        b = (byte)(0xFF & (b & 255 >>> 8 - bits) << 8 - bits);
        this.rawSet(pos / 8, (byte)(0xFF & (this.rawGet(pos / 8) & 255 << 8 - pos % 8 | (b & 0xFF) >>> pos % 8)));
        if (8 - pos % 8 < bits) {
            this.rawSet(pos / 8 + 1, (byte)(0xFF & (b & 0xFF) << 8 - pos % 8));
        }
        return this;
    }

    @Override
    public boolean getBoolean() {
        int pos = this.offset + this.position;
        this.advance(1, false);
        boolean result = (this.rawGet(pos / 8) & 128 >>> pos % 8) > 0;
        return result;
    }

    @Override
    public byte getByte() {
        int pos = this.offset + this.position;
        this.advance(8, false);
        byte b = (byte)((this.rawGet(pos / 8) & 255 >>> pos % 8) << pos % 8);
        b = pos % 8 > 0 ? (byte)(b | (0xFF & this.rawGet(pos / 8 + 1)) >>> 8 - pos % 8) : b;
        return b;
    }

    @Override
    public byte getByte(int bits) {
        int pos = this.offset + this.position;
        this.advance(bits, false);
        boolean sign = (this.rawGet(pos / 8) & 128 >>> pos % 8) > 0;
        short mask = (short)((65280 << 8 - --bits & 0xFFFF) >>> ++pos % 8);
        int b = (this.rawGet(pos / 8) & (mask & 0xFF00) >>> 8) << pos % 8;
        if (8 - pos % 8 < bits) {
            b = (byte)(b | (0xFF & (this.rawGet(pos / 8 + 1) & (mask & 0xFF))) >>> bits - (pos % 8 + bits - 8));
        }
        b = (byte)((b & 0xFF) >>> 8 - bits);
        return (byte)(sign ? 255 << bits & 0xFF | b : b);
    }

    @Override
    public byte getByteUnsigned(int bits) {
        int pos = this.offset + this.position;
        this.advance(bits, false);
        short mask = (short)((65280 << 8 - bits & 0xFFFF) >>> pos % 8);
        byte b = (byte)((this.rawGet(pos / 8) & (mask & 0xFF00) >>> 8) << pos % 8);
        if (8 - pos % 8 < bits) {
            b = (byte)(b | (0xFF & (this.rawGet(pos / 8 + 1) & (mask & 0xFF))) >>> bits - (pos % 8 + bits - 8));
        }
        b = (byte)((b & 0xFF) >>> 8 - bits);
        return b;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public BitBuffer size(int size) {
        this.size = size;
        return this;
    }

    @Override
    public int limit() {
        return this.rawLength();
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.size();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BitBuffer)) {
            return false;
        }
        BitBuffer other = (BitBuffer)obj;
        int size = this.size();
        if (this.size() != other.size()) {
            return false;
        }
        int mark = this.position();
        int otherMark = other.position();
        try {
            int i = 0;
            while (i < size) {
                if (size - i > 7) {
                    byte b;
                    byte a = this.getByte();
                    if (a != (b = other.getByte())) {
                        boolean bl = false;
                        return bl;
                    }
                    i += 7;
                    continue;
                }
                ++i;
                if (this.getBoolean() == other.getBoolean()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.position(mark);
            other.position(otherMark);
        }
        return true;
    }

    @Override
    public BitBuffer position(int newPosition) {
        this.position = newPosition;
        return this;
    }

    public int offset() {
        return this.offset;
    }
}

