/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseInventoryMonzaQT
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private ParamEpcFilter filter;
    private String hexPassword;
    private int qtParameter = Integer.MAX_VALUE;

    public MsgBaseInventoryMonzaQT() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)20;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseInventoryMonzaQT(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.inventoryMode = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[len];
                        if (len <= 0) break;
                        buffer.get(paramData);
                        this.filter = new ParamEpcFilter(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[4];
                        buffer.get(paramData);
                        this.hexPassword = HexUtils.bytes2HexString(paramData);
                        break;
                    }
                    case 3: {
                        this.qtParameter = buffer.getIntUnsigned(16);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public int getQtParameter() {
        return this.qtParameter;
    }

    public void setQtParameter(int qtParameter) {
        this.qtParameter = qtParameter;
    }

    @Override
    public void pack() {
        try {
            byte[] tmpByte;
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            buffer.putLong(this.inventoryMode, 8);
            if (null != this.filter) {
                buffer.putInt(1, 8);
                tmpByte = this.filter.toBytes();
                buffer.putInt(tmpByte.length, 16);
                buffer.put(tmpByte);
            }
            if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
                buffer.putInt(2, 8);
                tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
                buffer.put(tmpByte);
            }
            if (Integer.MAX_VALUE != this.qtParameter) {
                buffer.putInt(3, 8);
                buffer.put(this.qtParameter, 16);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "QT parameter error.");
                this.put((byte)4, "CRC verify parameter error.");
                this.put((byte)5, "Underpower error.");
                this.put((byte)6, "Access password error.");
                this.put((byte)7, "Other tag errors.");
                this.put((byte)8, "Tag missing.");
                this.put((byte)9, "Send command error.");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
        BitBuffer buffer = BitBuffer.wrap(this.cData);
        buffer.position(8);
        if (buffer.getIntUnsigned(8) == 1) {
            this.qtParameter = buffer.getIntUnsigned(16);
        }
    }
}

