/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.protocol.gx.ParamEpcReadTid;
import com.gg.reader.api.protocol.gx.ParamGbReadUserdata;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseInventoryGb
extends Message {
    private Long antennaEnable;
    private int inventoryMode;
    private ParamEpcFilter filter;
    private ParamEpcReadTid readTid;
    private ParamGbReadUserdata readUserdata;
    private String hexPassword;
    private int safeCertificationFlag = Integer.MAX_VALUE;
    private int timeout = Integer.MAX_VALUE;

    public MsgBaseInventoryGb() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)80;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseInventoryGb(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.inventoryMode = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[len];
                        if (len <= 0) break;
                        buffer.get(paramData);
                        this.filter = new ParamEpcFilter(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.readTid = new ParamEpcReadTid(paramData);
                        break;
                    }
                    case 3: {
                        byte[] paramData = new byte[4];
                        buffer.get(paramData);
                        this.readUserdata = new ParamGbReadUserdata(paramData);
                        break;
                    }
                    case 5: {
                        byte[] paramData = new byte[4];
                        buffer.get(paramData);
                        this.hexPassword = HexUtils.bytes2HexString(paramData);
                        break;
                    }
                    case 6: {
                        this.safeCertificationFlag = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 23: {
                        this.timeout = buffer.getIntUnsigned(32);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getInventoryMode() {
        return this.inventoryMode;
    }

    public void setInventoryMode(int inventoryMode) {
        this.inventoryMode = inventoryMode;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    public ParamEpcReadTid getReadTid() {
        return this.readTid;
    }

    public void setReadTid(ParamEpcReadTid readTid) {
        this.readTid = readTid;
    }

    public ParamGbReadUserdata getReadUserdata() {
        return this.readUserdata;
    }

    public void setReadUserdata(ParamGbReadUserdata readUserdata) {
        this.readUserdata = readUserdata;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public int getSafeCertificationFlag() {
        return this.safeCertificationFlag;
    }

    public void setSafeCertificationFlag(int safeCertificationFlag) {
        this.safeCertificationFlag = safeCertificationFlag;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public void pack() {
        byte[] tmpByte;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        buffer.putLong(this.inventoryMode, 8);
        if (null != this.filter) {
            buffer.putInt(1, 8);
            tmpByte = this.filter.toBytes();
            buffer.putInt(tmpByte.length, 16);
            buffer.put(tmpByte);
        }
        if (null != this.readTid) {
            buffer.putInt(2, 8);
            tmpByte = this.readTid.toBytes();
            buffer.put(tmpByte);
        }
        if (null != this.readUserdata) {
            buffer.putInt(3, 8);
            tmpByte = this.readUserdata.toBytes();
            buffer.put(tmpByte);
        }
        if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
            buffer.putInt(5, 8);
            tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
            buffer.put(tmpByte);
        }
        if (Integer.MAX_VALUE != this.safeCertificationFlag) {
            buffer.put(6, 8);
            buffer.put(this.safeCertificationFlag, 8);
        }
        if (this.timeout != Integer.MAX_VALUE) {
            buffer.putInt(23, 8);
            buffer.putInt(this.timeout, 32);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "Tid parameter error.");
                this.put((byte)4, "Userdata parameter error.");
                this.put((byte)5, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }

    public String toString() {
        return "MsgBaseInventoryGb{antennaEnable=" + this.antennaEnable + ", inventoryMode=" + this.inventoryMode + ", filter=" + this.filter + ", readTid=" + this.readTid + ", readUserdata=" + this.readUserdata + ", hexPassword='" + this.hexPassword + '\'' + ", safeCertificationFlag=" + this.safeCertificationFlag + '}';
    }
}

