/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.ArrayList;
import java.util.List;

public class MsgBaseGetCapabilities
extends Message {
    private int minPower;
    private int maxPower;
    private int antennaCount;
    private List<Integer> frequencyArray;
    private List<Integer> protocolArray;

    public MsgBaseGetCapabilities() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = 0;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetCapabilities(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.minPower = buffer.getIntUnsigned(8);
            this.maxPower = buffer.getIntUnsigned(8);
            this.antennaCount = buffer.getIntUnsigned(8);
            int freLen = buffer.getIntUnsigned(16);
            if (null == this.frequencyArray) {
                this.frequencyArray = new ArrayList<Integer>();
            }
            for (int i = 0; i < freLen; ++i) {
                this.frequencyArray.add(buffer.getIntUnsigned(8));
            }
            int proLen = buffer.getIntUnsigned(16);
            if (null == this.protocolArray) {
                this.protocolArray = new ArrayList<Integer>();
            }
            for (int i = 0; i < proLen; ++i) {
                this.protocolArray.add(buffer.getIntUnsigned(8));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(int maxPower) {
        this.maxPower = maxPower;
    }

    public int getMinPower() {
        return this.minPower;
    }

    public void setMinPower(int minPower) {
        this.minPower = minPower;
    }

    public int getAntennaCount() {
        return this.antennaCount;
    }

    public void setAntennaCount(int antennaCount) {
        this.antennaCount = antennaCount;
    }

    public List<Integer> getFrequencyArray() {
        return this.frequencyArray;
    }

    public void setFrequencyArray(List<Integer> frequencyArray) {
        this.frequencyArray = frequencyArray;
    }

    public List<Integer> getProtocolArray() {
        return this.protocolArray;
    }

    public void setProtocolArray(List<Integer> protocolArray) {
        this.protocolArray = protocolArray;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.minPower, 8);
            buffer.putLong(this.maxPower, 8);
            buffer.putLong(this.antennaCount, 8);
            if (null != this.frequencyArray && this.frequencyArray.size() > 0) {
                buffer.putInt(this.frequencyArray.size(), 16);
                for (int b : this.frequencyArray) {
                    buffer.putLong(b, 8);
                }
            }
            if (null != this.protocolArray && this.protocolArray.size() > 0) {
                buffer.putInt(this.protocolArray.size(), 16);
                for (int b : this.protocolArray) {
                    buffer.putLong(b, 8);
                }
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 8) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.minPower = buffer.getIntUnsigned(8);
            this.maxPower = buffer.getIntUnsigned(8);
            this.antennaCount = buffer.getIntUnsigned(8);
            int freqLen = buffer.getIntUnsigned(16);
            if (null == this.frequencyArray) {
                this.frequencyArray = new ArrayList<Integer>();
            }
            for (int i = 0; i < freqLen; ++i) {
                this.frequencyArray.add(buffer.getIntUnsigned(8));
            }
            int proLen = buffer.getIntUnsigned(16);
            if (null == this.protocolArray) {
                this.protocolArray = new ArrayList<Integer>();
            }
            for (int i = 0; i < proLen; ++i) {
                this.protocolArray.add(buffer.getIntUnsigned(8));
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetCapabilities{minPower=" + this.minPower + ", maxPower=" + this.maxPower + ", antennaCount=" + this.antennaCount + ", frequencyArray=" + this.frequencyArray + ", protocolArray=" + this.protocolArray + '}';
    }
}

