/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import java.util.Hashtable;

public class MsgAppSetWiegand
extends Message {
    private int wiegandSwitch;
    private int wiegandFormat;
    private int wiegandContent;
    private int negativePulseWidth = Integer.MAX_VALUE;
    private int pulseInterval = Integer.MAX_VALUE;

    public MsgAppSetWiegand() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)13;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetWiegand(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.wiegandSwitch = buffer.getIntUnsigned(8);
            this.wiegandFormat = buffer.getIntUnsigned(8);
            this.wiegandContent = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.negativePulseWidth = HexUtils.bytes2Int(paramData);
                        break;
                    }
                    case 2: {
                        byte[] paramData = new byte[2];
                        buffer.get(paramData);
                        this.pulseInterval = HexUtils.bytes2Int(paramData);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getWiegandSwitch() {
        return this.wiegandSwitch;
    }

    public void setWiegandSwitch(int wiegandSwitch) {
        this.wiegandSwitch = wiegandSwitch;
    }

    public int getWiegandFormat() {
        return this.wiegandFormat;
    }

    public void setWiegandFormat(int wiegandFormat) {
        this.wiegandFormat = wiegandFormat;
    }

    public int getWiegandContent() {
        return this.wiegandContent;
    }

    public void setWiegandContent(int wiegandContent) {
        this.wiegandContent = wiegandContent;
    }

    public int getNegativePulseWidth() {
        return this.negativePulseWidth;
    }

    public void setNegativePulseWidth(int negativePulseWidth) {
        this.negativePulseWidth = negativePulseWidth;
    }

    public int getPulseInterval() {
        return this.pulseInterval;
    }

    public void setPulseInterval(int pulseInterval) {
        this.pulseInterval = pulseInterval;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.wiegandSwitch, 8);
        buffer.putLong(this.wiegandFormat, 8);
        buffer.putLong(this.wiegandContent, 8);
        if (Integer.MAX_VALUE != this.negativePulseWidth) {
            buffer.putInt(1, 8);
            buffer.put(this.negativePulseWidth, 16);
        }
        if (Integer.MAX_VALUE != this.pulseInterval) {
            buffer.putInt(2, 8);
            buffer.put(this.pulseInterval, 16);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Reader hardware is not supported Wigan port.");
                this.put((byte)2, "Wiegand communication format not supported by reader .");
                this.put((byte)3, "Data content not supported by the reader");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

