/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.ActionParamFail;
import com.gg.reader.api.protocol.gx.ActionParamSuccess;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgAppSetEasAlarm
extends Message {
    private int alarmSwitch;
    private int filterData;
    private int start;
    private String hexContent;
    private byte[] byteContent;
    private String hexMask;
    private byte[] byteMask;
    private ActionParamSuccess success;
    private ActionParamFail fail;

    public MsgAppSetEasAlarm() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)63;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetEasAlarm(byte[] data) {
        this();
        try {
            int maskLen;
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.alarmSwitch = buffer.getIntUnsigned(8);
            this.filterData = buffer.getIntUnsigned(8);
            this.start = buffer.getIntUnsigned(16);
            int dataLen = buffer.getIntUnsigned(16);
            if (dataLen > 0) {
                this.byteContent = buffer.get(new byte[dataLen]);
                this.hexContent = HexUtils.bytes2HexString(this.byteContent);
            }
            if ((maskLen = buffer.getIntUnsigned(16)) > 0) {
                this.byteMask = buffer.get(new byte[maskLen]);
                this.hexMask = HexUtils.bytes2HexString(this.byteMask);
            }
            while (buffer.position() / 8 < data.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        int sucLen = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[sucLen];
                        buffer.get(paramData);
                        this.success = new ActionParamSuccess(paramData);
                        break;
                    }
                    case 2: {
                        int failLen = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[failLen];
                        buffer.get(paramData);
                        this.fail = new ActionParamFail(paramData);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAlarmSwitch() {
        return this.alarmSwitch;
    }

    public void setAlarmSwitch(int alarmSwitch) {
        this.alarmSwitch = alarmSwitch;
    }

    public int getFilterData() {
        return this.filterData;
    }

    public void setFilterData(int filterData) {
        this.filterData = filterData;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getHexContent() {
        return this.hexContent;
    }

    public void setHexContent(String hexContent) {
        this.hexContent = hexContent;
        if (!StringUtils.isNullOfEmpty(hexContent)) {
            this.byteContent = HexUtils.hexString2Bytes(this.hexContent);
        }
    }

    public byte[] getByteContent() {
        return this.byteContent;
    }

    public void setByteContent(byte[] byteContent) {
        this.byteContent = byteContent;
    }

    public String getHexMask() {
        return this.hexMask;
    }

    public void setHexMask(String hexMask) {
        this.hexMask = hexMask;
        if (!StringUtils.isNullOfEmpty(hexMask)) {
            this.byteMask = HexUtils.hexString2Bytes(this.hexMask);
        }
    }

    public byte[] getByteMask() {
        return this.byteMask;
    }

    public void setByteMask(byte[] byteMask) {
        this.byteMask = byteMask;
    }

    public ActionParamSuccess getSuccess() {
        return this.success;
    }

    public void setSuccess(ActionParamSuccess success) {
        this.success = success;
    }

    public ActionParamFail getFail() {
        return this.fail;
    }

    public void setFail(ActionParamFail fail) {
        this.fail = fail;
    }

    @Override
    public void pack() {
        byte[] tmpByte;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putInt(this.alarmSwitch, 8);
        buffer.putInt(this.filterData, 8);
        buffer.putInt(this.start, 16);
        if (null != this.byteContent && this.byteContent.length > 0) {
            buffer.putInt(this.byteContent.length, 16);
            buffer.put(this.byteContent);
        }
        if (null != this.byteMask && this.byteMask.length > 0) {
            buffer.putInt(this.byteMask.length, 16);
            buffer.put(this.byteMask);
        }
        if (null != this.success) {
            buffer.putInt(1, 8);
            tmpByte = this.success.toBytes();
            buffer.putInt(tmpByte.length, 16);
            buffer.put(tmpByte);
        }
        if (null != this.fail) {
            buffer.putInt(2, 8);
            tmpByte = this.fail.toBytes();
            buffer.putInt(tmpByte.length, 16);
            buffer.put(tmpByte);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Set failure.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

