/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.entity.WifiHotspotInfo;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.JsonReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class MsgAppGetWifiHotspotSearch
extends Message {
    private Long searchResultPacketNumber;
    private byte[] packetContent;
    private JsonReader jsonReader;

    public MsgAppGetWifiHotspotSearch() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)50;
            this.jsonReader = new JsonReader();
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetWifiHotspotSearch(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.searchResultPacketNumber = buffer.getLongUnsigned(32);
            int len = buffer.getIntUnsigned(16);
            byte[] packetData = new byte[len];
            if (len > 0) {
                this.packetContent = buffer.get(packetData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getSearchResultPacketNumber() {
        return this.searchResultPacketNumber;
    }

    public void setSearchResultPacketNumber(Long searchResultPacketNumber) {
        this.searchResultPacketNumber = searchResultPacketNumber;
    }

    public byte[] getPacketContent() {
        return this.packetContent;
    }

    public void setPacketContent(byte[] packetContent) {
        this.packetContent = packetContent;
    }

    public WifiHotspotInfo getWifiFormatterParam(byte[] packetContent) {
        try {
            if (packetContent != null && packetContent.length > 0) {
                return this.jsonReader.jsonToClass(new String(packetContent, "UTF-8"), WifiHotspotInfo.class);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.searchResultPacketNumber, 32);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.searchResultPacketNumber, 32);
            if (null != this.packetContent && this.packetContent.length > 0) {
                buffer.putInt(this.packetContent.length, 16);
                buffer.put(this.packetContent, 8);
            } else {
                buffer.putInt(0, 16);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.searchResultPacketNumber = buffer.getLongUnsigned(32);
            int len = buffer.getIntUnsigned(16);
            byte[] packetData = new byte[len];
            if (len > 0) {
                this.packetContent = buffer.get(packetData);
            }
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgAppGetWifiHotspotSearch{searchResultPacketNumber=" + this.searchResultPacketNumber + ", packetContent=" + Arrays.toString(this.packetContent) + '}';
    }
}

