/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.DateTimeUtils;
import com.gg.reader.api.utils.HexUtils;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.TimeZone;

public class LogBaseTLInfo
extends Message {
    private int tagType;
    private String epc;
    private byte[] bEpc;
    private String tid;
    private int antId;
    private int rssi;
    private int childAntId;
    private String strUtc;
    private Long frequencyPoint;
    private int phase;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private int rssidBm;
    private String readerSerialNumber;

    public int getTagType() {
        return this.tagType;
    }

    public void setTagType(int tagType) {
        this.tagType = tagType;
    }

    public String getEpc() {
        return this.epc;
    }

    public void setEpc(String epc) {
        this.epc = epc;
    }

    public byte[] getbEpc() {
        return this.bEpc;
    }

    public void setbEpc(byte[] bEpc) {
        this.bEpc = bEpc;
    }

    public int getAntId() {
        return this.antId;
    }

    public void setAntId(int antId) {
        this.antId = antId;
    }

    public int getRssi() {
        return this.rssi;
    }

    public void setRssi(int rssi) {
        this.rssi = rssi;
    }

    public String getStrUtc() {
        return this.strUtc;
    }

    public void setStrUtc(String strUtc) {
        this.strUtc = strUtc;
    }

    public Long getFrequencyPoint() {
        return this.frequencyPoint;
    }

    public void setFrequencyPoint(Long frequencyPoint) {
        this.frequencyPoint = frequencyPoint;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int getRssidBm() {
        return this.rssidBm;
    }

    public void setRssidBm(int rssidBm) {
        this.rssidBm = rssidBm;
    }

    public int getChildAntId() {
        return this.childAntId;
    }

    public void setChildAntId(int childAntId) {
        this.childAntId = childAntId;
    }

    public String getReaderSerialNumber() {
        return this.readerSerialNumber;
    }

    public void setReaderSerialNumber(String readerSerialNumber) {
        this.readerSerialNumber = readerSerialNumber;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    private String tlByteToAscii(byte[] bytes) {
        BitBuffer buffer = BitBuffer.wrap(bytes);
        int bit6ByteLen = bytes.length * 8 / 6;
        byte[] asciiByte = new byte[bit6ByteLen - 1];
        int i = 0;
        while (i < bytes.length * 8) {
            if (buffer.position() == 60 || buffer.position() == 124) {
                buffer.getByte(4);
                i += 4;
                continue;
            }
            byte aByte = buffer.getByte(6);
            asciiByte[buffer.position() / 6 - 1] = (byte)(aByte + 32);
            i += 6;
        }
        return new String(asciiByte, StandardCharsets.US_ASCII);
    }

    @Override
    public void pack() {
        super.pack();
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.tagType = buffer.getIntUnsigned(8);
            int epcLen = buffer.getIntUnsigned(16);
            this.bEpc = new byte[epcLen];
            this.bEpc = buffer.get(this.bEpc);
            if (this.bEpc.length > 0) {
                this.epc = HexUtils.bytes2HexString(this.bEpc);
                if (this.tagType == 0) {
                    this.tid = this.tlByteToAscii(this.bEpc);
                }
            }
            this.antId = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < this.cData.length) {
                int index = buffer.getIntUnsigned(8);
                switch (index) {
                    case 1: {
                        this.rssi = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 6: {
                        this.childAntId = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 7: {
                        long utcSecond = buffer.getLong(32) * 1000L;
                        long utcMicrosecond = buffer.getLong(32) / 1000L;
                        long ms = utcSecond + utcMicrosecond;
                        this.strUtc = this.dateFormat.format(DateTimeUtils.fromUtcToTimeZone(ms, TimeZone.getDefault()));
                        break;
                    }
                    case 8: {
                        this.frequencyPoint = buffer.getLongUnsigned(32);
                        break;
                    }
                    case 9: {
                        this.phase = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 20: {
                        this.rssidBm = buffer.getInt(16);
                        break;
                    }
                }
            }
        }
    }

    public String toString() {
        return "LogBaseTLInfo{tagType=" + this.tagType + ", epc='" + this.epc + '\'' + ", bEpc=" + Arrays.toString(this.bEpc) + ", tid='" + this.tid + '\'' + ", antId=" + this.antId + ", rssi=" + this.rssi + ", childAntId=" + this.childAntId + ", strUtc='" + this.strUtc + '\'' + ", frequencyPoint=" + this.frequencyPoint + ", phase=" + this.phase + ", dateFormat=" + this.dateFormat + ", rssidBm=" + this.rssidBm + ", readerSerialNumber='" + this.readerSerialNumber + '\'' + '}';
    }

    public String toHexString() {
        return "HexString{" + HexUtils.bytes2HexString(this.cData) + '}';
    }
}

