/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal;

import com.gg.reader.api.dal.ClientManualResetEvent;
import com.gg.reader.api.dal.HandlerAllGpiState;
import com.gg.reader.api.dal.HandlerCacheDataOver;
import com.gg.reader.api.dal.HandlerDebugLog;
import com.gg.reader.api.dal.HandlerGpiOver;
import com.gg.reader.api.dal.HandlerGpiStart;
import com.gg.reader.api.dal.HandlerSerialPortDisconnected;
import com.gg.reader.api.dal.HandlerTag6bLog;
import com.gg.reader.api.dal.HandlerTag6bOver;
import com.gg.reader.api.dal.HandlerTagEpcLog;
import com.gg.reader.api.dal.HandlerTagEpcOver;
import com.gg.reader.api.dal.HandlerTagGJbLog;
import com.gg.reader.api.dal.HandlerTagGJbOver;
import com.gg.reader.api.dal.HandlerTagGbLog;
import com.gg.reader.api.dal.HandlerTagGbOver;
import com.gg.reader.api.dal.HandlerTagGbSafeParam;
import com.gg.reader.api.dal.HandlerTagTLLog;
import com.gg.reader.api.dal.HandlerTagTLOver;
import com.gg.reader.api.dal.HandlerTcpDisconnected;
import com.gg.reader.api.dal.HandlerUsbHidEvent;
import com.gg.reader.api.dal.communication.AndroidPdaSerialClient;
import com.gg.reader.api.dal.communication.AndroidSerialClient;
import com.gg.reader.api.dal.communication.AndroidSerialCusClient;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.HandlerDisconnected;
import com.gg.reader.api.dal.communication.HandlerMessageReceived;
import com.gg.reader.api.dal.communication.HandlerUsbHidRemoved;
import com.gg.reader.api.dal.communication.JSerialClient;
import com.gg.reader.api.dal.communication.SerialClient;
import com.gg.reader.api.dal.communication.TcpClient;
import com.gg.reader.api.dal.communication.UsbHidClient;
import com.gg.reader.api.protocol.gx.LogAppAllGpiState;
import com.gg.reader.api.protocol.gx.LogAppGpiOver;
import com.gg.reader.api.protocol.gx.LogAppGpiStart;
import com.gg.reader.api.protocol.gx.LogBase6bInfo;
import com.gg.reader.api.protocol.gx.LogBase6bOver;
import com.gg.reader.api.protocol.gx.LogBaseEpcInfo;
import com.gg.reader.api.protocol.gx.LogBaseEpcOver;
import com.gg.reader.api.protocol.gx.LogBaseGJbInfo;
import com.gg.reader.api.protocol.gx.LogBaseGJbOver;
import com.gg.reader.api.protocol.gx.LogBaseGbInfo;
import com.gg.reader.api.protocol.gx.LogBaseGbOver;
import com.gg.reader.api.protocol.gx.LogBaseGbSafeParam;
import com.gg.reader.api.protocol.gx.LogBaseTLInfo;
import com.gg.reader.api.protocol.gx.LogBaseTLOver;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppGetCacheTagData;
import com.gg.reader.api.protocol.gx.MsgAppHeartbeat;
import com.gg.reader.api.protocol.gx.MsgTestWorkModeInit;
import com.gg.reader.api.utils.GLog;
import com.gg.reader.api.utils.HexUtils;
import java.util.HashMap;
import org.hid4java.HidDevice;
import org.hid4java.event.HidServicesEvent;

public class GClient {
    private CommunicationInterface ci;
    private String name;
    private String serialNumber;
    private static final int MSG_TIME_OUT = 3000;
    private HashMap<Integer, ClientManualResetEvent> dicMre = new HashMap();
    public HandlerTagEpcLog onTagEpcLog;
    public HandlerTagEpcOver onTagEpcOver;
    public HandlerTag6bLog onTag6bLog;
    public HandlerTag6bOver onTag6bOver;
    public HandlerTagGbLog onTagGbLog;
    public HandlerTagGbOver onTagGbOver;
    public HandlerTagGJbLog onTagGJbLog;
    public HandlerTagGJbOver onTagGJbOver;
    public HandlerTagGbSafeParam onTagGbSafeParam;
    public HandlerGpiStart onGpiStart;
    public HandlerGpiOver onGpiOver;
    public HandlerAllGpiState onAllGpiState;
    public HandlerUsbHidEvent onUsbHidRemoved;
    public HandlerSerialPortDisconnected onSerialPortDisconnected;
    public HandlerTcpDisconnected onDisconnected;
    public HandlerTagTLLog onTagTLog;
    public HandlerTagTLOver onTagTLOver;
    public HandlerDebugLog debugLog;
    public HandlerCacheDataOver cacheDataOver;
    private boolean isPrint = true;
    private String initParam;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public int getConnectType() {
        if (null == this.ci) {
            return 255;
        }
        return this.ci.getConnectType();
    }

    public void setSendHeartBeat(boolean _isSendHeartbeat) {
        if (null != this.ci) {
            this.ci._isSendHeartbeat = _isSendHeartbeat;
        }
    }

    public void setPrint(boolean print) {
        this.isPrint = print;
    }

    public String getInitParam() {
        return this.initParam;
    }

    public void setInitParam(String initParam) {
        this.initParam = initParam;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagEpcLogEvent(LogBaseEpcInfo msg) {
        block6: {
            try {
                if (this.onTagEpcLog == null) break block6;
                HandlerTagEpcLog handlerTagEpcLog = this.onTagEpcLog;
                synchronized (handlerTagEpcLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagEpcLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagEpcOverEvent(LogBaseEpcOver msg) {
        block6: {
            try {
                if (this.onTagEpcOver == null) break block6;
                HandlerTagEpcOver handlerTagEpcOver = this.onTagEpcOver;
                synchronized (handlerTagEpcOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagEpcOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6bLogEvent(LogBase6bInfo msg) {
        block6: {
            try {
                if (this.onTag6bLog == null) break block6;
                HandlerTag6bLog handlerTag6bLog = this.onTag6bLog;
                synchronized (handlerTag6bLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6bLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTag6bOverEvent(LogBase6bOver msg) {
        block6: {
            try {
                if (this.onTag6bOver == null) break block6;
                HandlerTag6bOver handlerTag6bOver = this.onTag6bOver;
                synchronized (handlerTag6bOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTag6bOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbLogEvent(LogBaseGbInfo msg) {
        block6: {
            try {
                if (this.onTagGbLog == null) break block6;
                HandlerTagGbLog handlerTagGbLog = this.onTagGbLog;
                synchronized (handlerTagGbLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGbLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbOverEvent(LogBaseGbOver msg) {
        block6: {
            try {
                if (this.onTagGbOver == null) break block6;
                HandlerTagGbOver handlerTagGbOver = this.onTagGbOver;
                synchronized (handlerTagGbOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGbOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagTLLogEvent(LogBaseTLInfo msg) {
        block6: {
            try {
                if (this.onTagTLog == null) break block6;
                HandlerTagTLLog handlerTagTLLog = this.onTagTLog;
                synchronized (handlerTagTLLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagTLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagTLOverEvent(LogBaseTLOver msg) {
        block6: {
            try {
                if (this.onTagTLOver == null) break block6;
                HandlerTagTLOver handlerTagTLOver = this.onTagTLOver;
                synchronized (handlerTagTLOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagTLOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGJbLogEvent(LogBaseGJbInfo msg) {
        block6: {
            try {
                if (this.onTagGJbLog == null) break block6;
                HandlerTagGJbLog handlerTagGJbLog = this.onTagGJbLog;
                synchronized (handlerTagGJbLog) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGJbLog.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGJbOverEvent(LogBaseGJbOver msg) {
        block6: {
            try {
                if (this.onTagGJbOver == null) break block6;
                HandlerTagGJbOver handlerTagGJbOver = this.onTagGJbOver;
                synchronized (handlerTagGJbOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGJbOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerTagGbSafeParamEvent(LogBaseGbSafeParam msg) {
        block6: {
            try {
                if (this.onTagGbSafeParam == null) break block6;
                HandlerTagGbSafeParam handlerTagGbSafeParam = this.onTagGbSafeParam;
                synchronized (handlerTagGbSafeParam) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onTagGbSafeParam.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGpiStart(LogAppGpiStart msg) {
        block6: {
            try {
                if (this.onGpiStart == null) break block6;
                HandlerGpiStart handlerGpiStart = this.onGpiStart;
                synchronized (handlerGpiStart) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onGpiStart.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerGpiOver(LogAppGpiOver msg) {
        block6: {
            try {
                if (this.onGpiOver == null) break block6;
                HandlerGpiOver handlerGpiOver = this.onGpiOver;
                synchronized (handlerGpiOver) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onGpiOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerAllGpiState(LogAppAllGpiState msg) {
        block6: {
            try {
                if (this.onAllGpiState == null) break block6;
                HandlerAllGpiState handlerAllGpiState = this.onAllGpiState;
                synchronized (handlerAllGpiState) {
                    if (this.serialNumber != null) {
                        msg.setReaderSerialNumber(this.serialNumber);
                    }
                    this.onAllGpiState.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerCacheDataOver(MsgAppGetCacheTagData msg) {
        block5: {
            try {
                if (this.cacheDataOver == null) break block5;
                HandlerCacheDataOver handlerCacheDataOver = this.cacheDataOver;
                synchronized (handlerCacheDataOver) {
                    this.cacheDataOver.log(this.name, msg);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerDisconnected() {
        block5: {
            try {
                if (this.onDisconnected == null) break block5;
                HandlerTcpDisconnected handlerTcpDisconnected = this.onDisconnected;
                synchronized (handlerTcpDisconnected) {
                    this.onDisconnected.log(this.name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerUsbHidRemoved(HidServicesEvent event) {
        block5: {
            try {
                if (this.onUsbHidRemoved == null) break block5;
                HandlerUsbHidEvent handlerUsbHidEvent = this.onUsbHidRemoved;
                synchronized (handlerUsbHidEvent) {
                    this.onUsbHidRemoved.hidDeviceDetached(event);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerSerialPortDisconnected() {
        block5: {
            try {
                if (this.onSerialPortDisconnected == null) break block5;
                HandlerSerialPortDisconnected handlerSerialPortDisconnected = this.onSerialPortDisconnected;
                synchronized (handlerSerialPortDisconnected) {
                    this.onSerialPortDisconnected.log(this.name);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean open(String readerName, CommunicationInterface client, int timeout) {
        if (null == client) {
            return false;
        }
        this.ci = client;
        this.ci.onMessageReceived = new HandlerMessageReceived(){

            @Override
            public void received(Message msg) {
                GClient.this.processMessage(msg);
            }
        };
        this.ci.onDisconnected = new HandlerDisconnected(){

            @Override
            public void log() {
                GClient.this.triggerDisconnected();
            }
        };
        if (this.ci.isConnected()) {
            this.name = readerName;
            this.ci.setConnectType(3);
            return true;
        }
        return false;
    }

    public boolean openSerial(String readerName, int timeout) {
        try {
            this.ci = new SerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createSerial(String initParam, String readerName, int timeout) {
        try {
            this.ci = new SerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openJSerial(String readerName) {
        try {
            this.ci = new JSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerSerialPortDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createJSerial(String initParam, String readerName) {
        try {
            this.ci = new JSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerSerialPortDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openSerial485(String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new SerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createSerial485(String initParam, String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new SerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openJSerial485(String readerName) {
        try {
            String[] param = readerName.split(":");
            if (param.length != 3) {
                return false;
            }
            this.ci = new JSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerSerialPortDisconnected();
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createJSerial485(String initParam, String readerName) {
        try {
            String[] param = readerName.split(":");
            if (param.length != 3) {
                return false;
            }
            this.ci = new JSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerSerialPortDisconnected();
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openAndroidSerial(String readerName, int timeout) {
        try {
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createAndroidSerial(String initParam, String readerName, int timeout) {
        try {
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openCusAndroidSerial(String readerName, int packageSize, int freeWait) {
        try {
            this.ci = new AndroidSerialCusClient(packageSize, freeWait);
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createCusAndroidSerial(String initParam, String readerName, int packageSize, int freeWait) {
        try {
            this.ci = new AndroidSerialCusClient(packageSize, freeWait);
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openAndroidRs485(String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createAndroidRs485(String initParam, String readerName, int timeout) {
        try {
            String[] param = readerName.split(":");
            if (null == param || param.length != 3) {
                return false;
            }
            this.ci = new AndroidSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(param[0] + ":" + param[1])) {
                this.name = readerName;
                this.ci.setConnectType(1);
                this.ci.setRs485(true);
                this.ci.setRs485Address(Integer.parseInt(param[2]));
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openHdSerial(String readerName, int timeout) {
        try {
            this.ci = new AndroidPdaSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createHdSerial(String initParam, String readerName, int timeout) {
        try {
            this.ci = new AndroidPdaSerialClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(0);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void hdPowerOn() {
        if (this.ci != null && this.ci instanceof AndroidPdaSerialClient) {
            this.ci.hdPowerOn();
        }
    }

    public void hdPowerOff() {
        if (this.ci != null && this.ci instanceof AndroidPdaSerialClient) {
            this.ci.hdPowerOff();
        }
    }

    public boolean openTcp(String readerName, int timeout) {
        try {
            this.ci = new TcpClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(2);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean createTcp(String initParam, String readerName, int timeout) {
        try {
            this.ci = new TcpClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onDisconnected = new HandlerDisconnected(){

                @Override
                public void log() {
                    GClient.this.triggerDisconnected();
                }
            };
            if (this.ci.open(readerName)) {
                this.name = readerName;
                this.ci.setConnectType(2);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean openUsbHid(final HidDevice device) {
        try {
            this.ci = new UsbHidClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onUsbHidRemoved = new HandlerUsbHidRemoved(){

                @Override
                public void hidDeviceDetached(HidServicesEvent event) {
                    if (event.getHidDevice().getPath().equals(device.getPath())) {
                        GClient.this.triggerUsbHidRemoved(event);
                    }
                }
            };
            if (this.ci.open(device)) {
                this.name = device.getPath();
                this.ci.setConnectType(4);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean createUsbHid(String initParam, final HidDevice device) {
        try {
            this.ci = new UsbHidClient();
            this.ci.onMessageReceived = new HandlerMessageReceived(){

                @Override
                public void received(Message msg) {
                    GClient.this.processMessage(msg);
                }
            };
            this.ci.onUsbHidRemoved = new HandlerUsbHidRemoved(){

                @Override
                public void hidDeviceDetached(HidServicesEvent event) {
                    if (event.getHidDevice().getPath().equals(device.getPath())) {
                        GClient.this.triggerUsbHidRemoved(event);
                    }
                }
            };
            if (this.ci.open(device)) {
                this.name = device.getPath();
                this.ci.setConnectType(4);
                this.sendUnsynMsg(new MsgTestWorkModeInit(initParam, 0));
                this.initParam = initParam;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean close() {
        try {
            if (null != this.ci) {
                this.ci.close();
                this.ci.onMessageReceived = null;
                this.ci.onDisconnected = null;
                this.ci.onUsbHidRemoved = null;
                this.ci = null;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void sendSynMsg(Message msg, int timeout) {
        if (null == msg) {
            return;
        }
        if (this.getConnectType() == 1) {
            msg.msgType.mt_13 = "1";
        }
        int mreKey = msg.msgType.toInt();
        if (null == this.dicMre) {
            this.dicMre = new HashMap();
        }
        if (!this.dicMre.containsKey(mreKey)) {
            ClientManualResetEvent cmre = new ClientManualResetEvent(false);
            cmre.data = null;
            this.dicMre.put(mreKey, cmre);
        } else {
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data = null;
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).evt.reset();
        }
        try {
            this.ci.send(msg);
            if (this.isPrint && this.debugLog != null) {
                this.debugLog.sendDebugLog("send-[" + msg.getClass().getName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
            }
            this.dicMre.get((Object)Integer.valueOf((int)mreKey)).evt.waitOne(timeout);
            if (null != this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data) {
                msg.msgData = this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data.msgData;
                msg.ackUnpack(this.dicMre.get((Object)Integer.valueOf((int)mreKey)).data.cData);
                if (this.isPrint && this.debugLog != null) {
                    this.debugLog.receiveDebugLog("receive-[" + msg.getClass().getName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendSynMsg(Message msg) {
        this.sendSynMsg(msg, 3000);
    }

    public void sendSynMsgRetry(Message msg, int timeout, int retry) {
        for (int i = 0; i < retry; ++i) {
            this.sendSynMsg(msg, timeout);
            if (0 == msg.getRtCode()) break;
        }
    }

    public void sendUnsynMsg(Message msg) {
        if (null == msg) {
            return;
        }
        this.ci.send(msg);
        if (this.isPrint && this.debugLog != null) {
            this.debugLog.sendDebugLog("send-[" + msg.getClass().getName() + "]-[" + HexUtils.bytes2HexString(msg.msgData) + "]");
        }
    }

    public void sendUnsynMsg(byte[] msg) {
        if (null == msg) {
            return;
        }
        this.ci.send(msg);
        if (this.isPrint && this.debugLog != null) {
            this.debugLog.sendDebugLog("send-[custom]-[" + HexUtils.bytes2HexString(msg) + "]");
        }
    }

    public void sendUnsynMsgRetry(Message msg, int retry) {
        for (int i = 0; i < retry; ++i) {
            this.sendUnsynMsg(msg);
        }
    }

    public void processMessage(Message msg) {
        try {
            if (null == msg) {
                return;
            }
            if (msg.msgType.mt_12.equals("0")) {
                ClientManualResetEvent event;
                int mreKey = msg.msgType.toInt();
                if (this.dicMre.containsKey(mreKey) && (event = this.dicMre.get(mreKey)) != null) {
                    event.data = msg;
                    event.evt.set();
                }
            } else if (msg.msgType.mt_8_11.equals("0010")) {
                if (0 == msg.msgType.msgId) {
                    LogBaseEpcInfo log = new LogBaseEpcInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagEpcLogEvent(log);
                } else if (32 == msg.msgType.msgId) {
                    LogBase6bInfo log = new LogBase6bInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6bLogEvent(log);
                } else if (48 == msg.msgType.msgId) {
                    LogBaseGbInfo log = new LogBaseGbInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbLogEvent(log);
                } else if (64 == msg.msgType.msgId) {
                    LogBaseGJbInfo log = new LogBaseGJbInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGJbLogEvent(log);
                } else if (1 == msg.msgType.msgId) {
                    LogBaseEpcOver log = new LogBaseEpcOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagEpcOverEvent(log);
                } else if (33 == msg.msgType.msgId) {
                    LogBase6bOver log = new LogBase6bOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTag6bOverEvent(log);
                } else if (49 == msg.msgType.msgId) {
                    LogBaseGbOver log = new LogBaseGbOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbOverEvent(log);
                } else if (65 == msg.msgType.msgId) {
                    LogBaseGJbOver log = new LogBaseGJbOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGJbOverEvent(log);
                } else if (50 == msg.msgType.msgId) {
                    LogBaseGbSafeParam log = new LogBaseGbSafeParam();
                    log.ackUnpack(msg.cData);
                    this.triggerTagGbSafeParamEvent(log);
                } else if (80 == msg.msgType.msgId) {
                    LogBaseTLInfo log = new LogBaseTLInfo();
                    log.ackUnpack(msg.cData);
                    this.triggerTagTLLogEvent(log);
                } else if (81 == msg.msgType.msgId) {
                    LogBaseTLOver log = new LogBaseTLOver();
                    log.ackUnpack(msg.cData);
                    this.triggerTagTLOverEvent(log);
                }
            } else if (msg.msgType.mt_8_11.equals("0001")) {
                Message log;
                if (18 == msg.msgType.msgId) {
                    if (this.isPrint) {
                        GLog.d("[heartbeat]");
                    }
                    MsgAppHeartbeat msgAppHeartbeat = new MsgAppHeartbeat();
                    msgAppHeartbeat.msgType = msg.msgType;
                    msgAppHeartbeat.ackUnpack(msg.cData);
                    this.sendUnsynMsg(msgAppHeartbeat);
                }
                if (0 == msg.msgType.msgId) {
                    log = new LogAppGpiStart();
                    log.ackUnpack(msg.cData);
                    this.triggerGpiStart((LogAppGpiStart)log);
                } else if (1 == msg.msgType.msgId) {
                    log = new LogAppGpiOver();
                    log.ackUnpack(msg.cData);
                    this.triggerGpiOver((LogAppGpiOver)log);
                } else if (2 == msg.msgType.msgId) {
                    log = new LogAppAllGpiState();
                    log.ackUnpack(msg.cData);
                    this.triggerAllGpiState((LogAppAllGpiState)log);
                } else if (27 == msg.msgType.msgId) {
                    MsgAppGetCacheTagData cacheTagData = new MsgAppGetCacheTagData();
                    cacheTagData.ackUnpack(msg.cData);
                    this.triggerCacheDataOver(cacheTagData);
                }
            } else if (msg.msgType.mt_8_11.equals("0101") && 2 == msg.msgType.msgId) {
                this.sendUnsynMsg(new MsgTestWorkModeInit(this.initParam, 0));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

