/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.utils;

public class RingBuffer {
    private byte[] Buffer = null;
    private int DataCount = 0;
    private int DataStart = 0;
    private int DataEnd = 0;

    public byte[] getBuffer() {
        return this.Buffer;
    }

    public void setBuffer(byte[] buffer) {
        this.Buffer = buffer;
    }

    public int getDataCount() {
        return this.DataCount;
    }

    public void setDataCount(int dataCount) {
        this.DataCount = dataCount;
    }

    public int getDataStart() {
        return this.DataStart;
    }

    public void setDataStart(int dataStart) {
        this.DataStart = dataStart;
    }

    public int getDataEnd() {
        return this.DataEnd;
    }

    public void setDataEnd(int dataEnd) {
        this.DataEnd = dataEnd;
    }

    public RingBuffer(int bufferSize) {
        this.setDataCount(0);
        this.setDataStart(0);
        this.setDataEnd(0);
        this.setBuffer(new byte[bufferSize]);
    }

    public byte Index(int index) throws Exception {
        if (index >= this.DataCount) {
            throw new Exception("\u73af\u5f62\u7f13\u51b2\u533a\u5f02\u5e38\uff0c\u7d22\u5f15\u6ea2\u51fa");
        }
        if (this.DataStart + index < this.Buffer.length) {
            return this.Buffer[this.DataStart + index];
        }
        return this.Buffer[this.DataStart + index - this.Buffer.length];
    }

    public int GetReserveCount() {
        return this.Buffer.length - this.DataCount;
    }

    public void Clear() {
        this.DataCount = 0;
    }

    public void Clear(int count) {
        if (count >= this.DataCount) {
            this.DataCount = 0;
            this.DataStart = 0;
            this.DataEnd = 0;
        } else {
            this.DataStart = this.DataStart + count >= this.Buffer.length ? this.DataStart + count - this.Buffer.length : (this.DataStart += count);
            this.DataCount -= count;
        }
    }

    public void WriteBuffer(byte[] buffer, int offset, int count) throws Exception {
        int reserveCount = this.Buffer.length - this.DataCount;
        if (reserveCount >= count) {
            if (this.DataEnd + count < this.Buffer.length) {
                System.arraycopy(buffer, offset, this.Buffer, this.DataEnd, count);
                this.DataEnd += count;
                this.DataCount += count;
            } else {
                int overflowIndexLength = this.DataEnd + count - this.Buffer.length;
                int endPushIndexLength = count - overflowIndexLength;
                System.arraycopy(buffer, offset, this.Buffer, this.DataEnd, endPushIndexLength);
                this.DataEnd = 0;
                offset += endPushIndexLength;
                this.DataCount += endPushIndexLength;
                if (overflowIndexLength != 0) {
                    System.arraycopy(buffer, offset, this.Buffer, this.DataEnd, overflowIndexLength);
                }
                this.DataEnd += overflowIndexLength;
                this.DataCount += overflowIndexLength;
            }
        }
    }

    public void WriteBuffer(byte[] buffer) throws Exception {
        this.WriteBuffer(buffer, 0, buffer.length);
    }

    public void ReadBuffer(byte[] targetBytes, int offset, int count) throws Exception {
        if (count > this.DataCount) {
            throw new Exception("\u73af\u5f62\u7f13\u51b2\u533a\u5f02\u5e38\uff0c\u8bfb\u53d6\u957f\u5ea6\u5927\u4e8e\u6570\u636e\u957f\u5ea6");
        }
        int tempDataStart = this.DataStart;
        if (this.DataStart + count < this.Buffer.length) {
            System.arraycopy(this.Buffer, this.DataStart, targetBytes, offset, count);
        } else {
            int overflowIndexLength = this.DataStart + count - this.Buffer.length;
            int endPushIndexLength = count - overflowIndexLength;
            System.arraycopy(this.Buffer, this.DataStart, targetBytes, offset, endPushIndexLength);
            offset += endPushIndexLength;
            if (overflowIndexLength != 0) {
                System.arraycopy(this.Buffer, 0, targetBytes, offset, overflowIndexLength);
            }
        }
    }
}

