/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Parameter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;

public class ParamEpcFilter
extends Parameter {
    private int area;
    private int bitStart;
    private int bitLength;
    private String hexData;
    private byte[] bData;

    public ParamEpcFilter() {
    }

    public ParamEpcFilter(int area, int bitStart, int bitLength, String hexData) {
        this.area = area;
        this.bitStart = bitStart;
        this.bitLength = bitLength;
        this.hexData = hexData;
        if (!StringUtils.isNullOfEmpty(hexData)) {
            this.bData = HexUtils.hexString2Bytes(this.hexData);
        }
    }

    public int getArea() {
        return this.area;
    }

    public void setArea(int area) {
        this.area = area;
    }

    public int getBitStart() {
        return this.bitStart;
    }

    public void setBitStart(int bitStart) {
        this.bitStart = bitStart;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public void setBitLength(int bitLength) {
        this.bitLength = bitLength;
    }

    public String getHexData() {
        return this.hexData;
    }

    public void setHexData(String hexData) {
        if (!StringUtils.isNullOfEmpty(hexData)) {
            this.hexData = hexData;
            this.bData = HexUtils.hexString2Bytes(this.hexData);
        }
    }

    public byte[] getbData() {
        return this.bData;
    }

    public void setbData(byte[] bData) {
        this.bData = bData;
    }

    public ParamEpcFilter(byte[] data) {
        if (null == data) {
            return;
        }
        try {
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.area = buffer.getIntUnsigned(8);
            this.bitStart = buffer.getIntUnsigned(16);
            this.bitLength = buffer.getIntUnsigned(8);
            int byteLength = this.bitLength / 8;
            this.bData = new byte[byteLength];
            if (byteLength > 0) {
                this.bData = buffer.get(this.bData);
                this.hexData = HexUtils.bytes2HexString(this.bData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public byte[] toBytes() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.area, 8);
        buffer.putLong(this.bitStart, 16);
        buffer.putLong(this.bitLength, 8);
        buffer.put(this.bData);
        return buffer.asByteArray();
    }
}

