/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.HashMap;

public class MsgTestEnvRssiDetection
extends Message {
    private Long antennaEnable;
    private int frequencyPoint;
    private Long rssiFrequency;
    private int currentRssi;

    public MsgTestEnvRssiDetection() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)7;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestEnvRssiDetection(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.frequencyPoint = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public int getFrequencyPoint() {
        return this.frequencyPoint;
    }

    public void setFrequencyPoint(int frequencyPoint) {
        this.frequencyPoint = frequencyPoint;
    }

    public Long getRssiFrequency() {
        return this.rssiFrequency;
    }

    public void setRssiFrequency(Long rssiFrequency) {
        this.rssiFrequency = rssiFrequency;
    }

    public int getCurrentRssi() {
        return this.currentRssi;
    }

    public void setCurrentRssi(int currentRssi) {
        this.currentRssi = currentRssi;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.antennaEnable, 32);
            buffer.putInt(this.frequencyPoint, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.putLong(this.rssiFrequency, 32);
            buffer.putInt(this.currentRssi, 8);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        HashMap<Byte, String> dicErrorMsg = new HashMap<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "FrequencyPoint Param Reader Not Support.");
                this.put((byte)2, "Port Param Reader Not Support.");
                this.put((byte)3, "Phase-locked loop locking failed");
                this.put((byte)4, "Other error");
            }
        };
        if (null != this.cData && this.cData.length > 0) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(8);
            this.rssiFrequency = buffer.getLongUnsigned(32);
            this.currentRssi = buffer.getIntUnsigned(8);
        }
    }

    public String toString() {
        return "MsgTestEnvRssiDetection{antennaEnable=" + this.antennaEnable + ", frequencyPoint=" + this.frequencyPoint + ", rssiFrequency=" + this.rssiFrequency + ", currentRssi=" + this.currentRssi + '}';
    }
}

