/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.protocol.gx.ParamEpcFilter;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseDestroyEpc
extends Message {
    private Long antennaEnable;
    private String hexPassword;
    private ParamEpcFilter filter;

    public MsgBaseDestroyEpc() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)19;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseDestroyEpc(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            byte[] bytes = buffer.get(new byte[4]);
            this.hexPassword = HexUtils.bytes2HexString(bytes);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int len = buffer.getIntUnsigned(16);
                        byte[] paramData = new byte[len];
                        if (len <= 0) break;
                        buffer.get(paramData);
                        this.filter = new ParamEpcFilter(paramData);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public String getHexPassword() {
        return this.hexPassword;
    }

    public void setHexPassword(String hexPassword) {
        this.hexPassword = hexPassword;
    }

    public ParamEpcFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ParamEpcFilter filter) {
        this.filter = filter;
    }

    @Override
    public void pack() {
        byte[] tmpByte;
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        if (!StringUtils.isNullOfEmpty(this.hexPassword)) {
            tmpByte = HexUtils.hexString2Bytes(this.hexPassword);
            buffer.put(tmpByte);
        }
        if (null != this.filter) {
            buffer.putInt(1, 8);
            tmpByte = this.filter.toBytes();
            buffer.putInt(tmpByte.length, 16);
            buffer.put(tmpByte);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Filter parameter error.");
                this.put((byte)3, "CRC check error.");
                this.put((byte)4, "Underpower error.");
                this.put((byte)5, "The inactivation password is incorrect.");
                this.put((byte)6, "Other error.");
                this.put((byte)7, "Label missing.");
                this.put((byte)8, "Command error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

