/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgAppSetWifiHotspot
extends Message {
    private String hotspotName;
    private String connectPassword;
    private int certificationType = Integer.MAX_VALUE;
    private int encryptionAlgorithm = Integer.MAX_VALUE;

    public MsgAppSetWifiHotspot() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)51;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetWifiHotspot(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            int hnLen = buffer.getIntUnsigned(16);
            if (hnLen > 0) {
                this.hotspotName = new String(buffer.get(new byte[hnLen]), "UTF-8");
            }
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        int pasLen = buffer.getIntUnsigned(16);
                        if (pasLen <= 0) break;
                        this.connectPassword = new String(buffer.get(new byte[pasLen]), "ASCII");
                        break;
                    }
                    case 2: {
                        this.certificationType = buffer.getIntUnsigned(8);
                        break;
                    }
                    case 3: {
                        this.encryptionAlgorithm = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getHotspotName() {
        return this.hotspotName;
    }

    public void setHotspotName(String hotspotName) {
        this.hotspotName = hotspotName;
    }

    public String getConnectPassword() {
        return this.connectPassword;
    }

    public void setConnectPassword(String connectPassword) {
        this.connectPassword = connectPassword;
    }

    public int getCertificationType() {
        return this.certificationType;
    }

    public void setCertificationType(int certificationType) {
        this.certificationType = certificationType;
    }

    public int getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(int encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        if (!StringUtils.isNullOfEmpty(this.hotspotName)) {
            buffer.putInt(this.hotspotName.length(), 16);
            buffer.put(this.hotspotName);
        }
        if (!StringUtils.isNullOfEmpty(this.connectPassword)) {
            buffer.putInt(1, 8);
            buffer.putInt(this.connectPassword.length(), 16);
            buffer.put(this.connectPassword);
        }
        if (Integer.MAX_VALUE != this.certificationType) {
            buffer.putInt(2, 8);
            buffer.putInt(this.certificationType, 8);
        }
        if (Integer.MAX_VALUE != this.encryptionAlgorithm) {
            buffer.putInt(3, 8);
            buffer.putInt(this.encryptionAlgorithm, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Set Fail.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

