/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgAppHeartbeat;
import com.gg.reader.api.utils.ThreadPoolUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;

public class TcpClient
extends CommunicationInterface {
    public Socket sConn = null;
    public String serverIp = "192.168.1.168";
    public int serverPort = 8160;
    public InputStream inputStream = null;
    public OutputStream outputStream = null;
    boolean _isOpen = false;
    private Date lastUrgentData = new Date();
    private int count = 1;

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        try {
            if (null != this.sConn && this.sConn.isConnected()) {
                return false;
            }
            this.sConn = sConn;
            this.keepReceived = true;
            sConn.setSoTimeout(1000);
            sConn.setKeepAlive(true);
            this.inputStream = sConn.getInputStream();
            this.outputStream = sConn.getOutputStream();
            this.startReceive();
            this.startProcess();
            return true;
        }
        catch (Exception ex) {
            this.close();
            return false;
        }
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            if (!this.isIpv6Address(param)) {
                String[] arrParam = param.split(":");
                this.serverIp = arrParam[0];
                this.serverPort = Integer.parseInt(arrParam[1]);
            } else {
                int i = param.lastIndexOf(":");
                this.serverIp = param.substring(0, i);
                this.serverPort = Integer.parseInt(param.substring(i + 1));
            }
            this.sConn = new Socket();
            this.sConn.connect(new InetSocketAddress(this.serverIp, this.serverPort), 5000);
            this.sConn.setSoTimeout(1000);
            this.sConn.setKeepAlive(true);
            this.inputStream = this.sConn.getInputStream();
            this.outputStream = this.sConn.getOutputStream();
            this.keepReceived = true;
            this.startReceive();
            this.startProcess();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            this._isOpen = false;
            if (null != this.sConn) {
                this.sConn.close();
                this.inputStream = null;
                this.outputStream = null;
                this.sConn = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
                this.ringBuffer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        TcpClient tcpClient = this;
        synchronized (tcpClient) {
            try {
                this.outputStream.write(data);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(Message msg) {
        try {
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    private boolean isRemoteClosed() {
        if (null == this.sConn) {
            return true;
        }
        Date now = new Date();
        if (now.getTime() - this.lastUrgentData.getTime() > (long)(3000 * this.count)) {
            try {
                ++this.count;
                this.send(new MsgAppHeartbeat());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return now.getTime() - this.lastUrgentData.getTime() > 15000L;
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (TcpClient.this.keepReceived) {
                    try {
                        int len = TcpClient.this.inputStream.available();
                        if (len <= 0) {
                            Thread.sleep(100L);
                        }
                        if (len > 0) {
                            len = TcpClient.this.inputStream.read(TcpClient.this.rcvBuff, 0, TcpClient.this.rcvBuff.length);
                            Object object = TcpClient.this.lockRingBuffer;
                            synchronized (object) {
                                while (len + TcpClient.this.ringBuffer.getDataCount() > 0x100000) {
                                    TcpClient.this.lockRingBuffer.wait(10000L);
                                }
                                TcpClient.this.ringBuffer.WriteBuffer(TcpClient.this.rcvBuff, 0, len);
                                TcpClient.this.lockRingBuffer.notify();
                            }
                        }
                        if (!TcpClient.this._isSendHeartbeat) continue;
                        if (len <= 0) {
                            if (!TcpClient.this.isRemoteClosed()) continue;
                            throw new Exception("remote closed.");
                        }
                        TcpClient.this.lastUrgentData = new Date();
                        TcpClient.this.count = 1;
                    }
                    catch (Exception ex) {
                        try {
                            TcpClient.this.triggerDisconnected();
                            Thread.sleep(3000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        });
    }

    private boolean isIpv6Address(String address) {
        try {
            int i = address.lastIndexOf(":");
            InetAddress inetAddress = InetAddress.getByName(address.substring(0, i));
            return inetAddress instanceof Inet6Address;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }
}

