/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.utils.ThreadPoolUtils;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;

public class SerialClient
extends CommunicationInterface
implements SerialPortEventListener {
    static CommPortIdentifier portId;
    static Enumeration portList;
    InputStream inputStream;
    OutputStream outputStream;
    SerialPort serialPort;
    String _PortName = "";
    int _BaudRate = 115200;
    boolean _isOpen = false;

    @Override
    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
    }

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    @Override
    public boolean open(String param) {
        try {
            String[] arrParam = param.split(":");
            if (arrParam.length == 2) {
                this._PortName = arrParam[0];
                this._BaudRate = Integer.parseInt(arrParam[1]);
                portId = CommPortIdentifier.getPortIdentifier(this._PortName);
                this.serialPort = (SerialPort)portId.open("myCOM", 2000);
                this.inputStream = this.serialPort.getInputStream();
                this.outputStream = this.serialPort.getOutputStream();
                this.serialPort.addEventListener(this);
                this.serialPort.notifyOnDataAvailable(true);
                this.serialPort.setSerialPortParams(this._BaudRate, 8, 1, 0);
                this.keepReceived = true;
                this.startReceive();
                this.startProcess();
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            this._isOpen = false;
            if (null != this.serialPort) {
                this.serialPort.close();
                this.inputStream = null;
                this.outputStream = null;
                this.serialPort = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
                this.ringBuffer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        SerialClient serialClient = this;
        synchronized (serialClient) {
            try {
                this.outputStream.write(data);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(Message msg) {
        try {
            if (this.isRs485) {
                msg.msgType.mt_13 = "1";
                msg.rs485Address = this.getRs485Address();
            }
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }

    public void startReceive() {
        ThreadPoolUtils.run(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (SerialClient.this.keepReceived) {
                    try {
                        int len = SerialClient.this.inputStream.available();
                        if (len <= 0) {
                            Thread.sleep(100L);
                        }
                        if (len <= 0) continue;
                        len = SerialClient.this.inputStream.read(SerialClient.this.rcvBuff, 0, SerialClient.this.rcvBuff.length);
                        Object object = SerialClient.this.lockRingBuffer;
                        synchronized (object) {
                            while (len + SerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                                SerialClient.this.lockRingBuffer.wait(10000L);
                            }
                            SerialClient.this.ringBuffer.WriteBuffer(SerialClient.this.rcvBuff, 0, len);
                            SerialClient.this.lockRingBuffer.notify();
                        }
                    }
                    catch (Exception ex) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        });
    }
}

