/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import com.gg.reader.api.utils.HexUtils;
import com.gg.reader.api.utils.StringUtils;
import java.util.Hashtable;

public class MsgBaseWrite6b
extends Message {
    private Long antennaEnable;
    private String hexMatchTid;
    private byte[] bMatchTid;
    private int start;
    private String hexWriteData;
    private byte[] bwriteData;
    private int errorIndex;

    public MsgBaseWrite6b() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)65;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseWrite6b(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.antennaEnable = buffer.getLongUnsigned(32);
            this.bMatchTid = buffer.get(new byte[8]);
            this.hexMatchTid = HexUtils.bytes2HexString(this.bMatchTid);
            this.start = buffer.getIntUnsigned(8);
            int len = buffer.getIntUnsigned(16);
            if (len > 0) {
                this.bwriteData = buffer.get(new byte[len]);
                this.hexWriteData = HexUtils.bytes2HexString(this.bwriteData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getAntennaEnable() {
        return this.antennaEnable;
    }

    public void setAntennaEnable(Long antennaEnable) {
        this.antennaEnable = antennaEnable;
    }

    public String getHexMatchTid() {
        return this.hexMatchTid;
    }

    public void setHexMatchTid(String hexMatchTid) {
        if (!StringUtils.isNullOfEmpty(hexMatchTid)) {
            this.hexMatchTid = hexMatchTid;
            this.bMatchTid = HexUtils.hexString2Bytes(this.hexMatchTid);
        }
    }

    public byte[] getbMatchTid() {
        return this.bMatchTid;
    }

    public void setbMatchTid(byte[] bMatchTid) {
        this.bMatchTid = bMatchTid;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getHexWriteData() {
        return this.hexWriteData;
    }

    public void setHexWriteData(String hexWriteData) {
        if (!StringUtils.isNullOfEmpty(hexWriteData)) {
            this.hexWriteData = hexWriteData;
            this.bwriteData = HexUtils.hexString2Bytes(this.hexWriteData);
        }
    }

    public byte[] getBwriteData() {
        return this.bwriteData;
    }

    public void setBwriteData(byte[] bwriteData) {
        this.bwriteData = bwriteData;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public void setErrorIndex(int errorIndex) {
        this.errorIndex = errorIndex;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.putLong(this.antennaEnable, 32);
        buffer.put(this.bMatchTid);
        buffer.putLong(this.start, 8);
        if (null != this.bwriteData && this.bwriteData.length > 0) {
            buffer.putInt(this.bwriteData.length, 16);
            buffer.put(this.bwriteData);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Antenna port parameter error.");
                this.put((byte)2, "Write parameter error.");
                this.put((byte)3, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length >= 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
            if (this.cData.length > 1) {
                BitBuffer buffer = BitBuffer.wrap(this.cData);
                buffer.position(8);
                if (buffer.getIntUnsigned(8) == 1) {
                    this.errorIndex = buffer.getIntUnsigned(8);
                }
            }
        }
    }
}

