/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgAppGetWhiteList
extends Message {
    private Long packetNumber;
    private byte[] packetContent;

    public MsgAppGetWhiteList() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)32;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppGetWhiteList(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.packetNumber = buffer.getLongUnsigned(32);
            int len = buffer.getIntUnsigned(16);
            byte[] packetData = new byte[len];
            if (len > 0) {
                this.packetContent = buffer.get(packetData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Long getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(Long packetNumber) {
        this.packetNumber = packetNumber;
    }

    public byte[] getPacketContent() {
        return this.packetContent;
    }

    public void setPacketContent(byte[] packetContent) {
        this.packetContent = packetContent;
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.put(this.packetNumber, 32);
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            buffer.put(this.packetNumber, 32);
            if (null != this.packetContent && this.packetContent.length > 0) {
                buffer.putInt(this.packetContent.length, 16);
                buffer.put(this.packetContent, 8);
            } else {
                buffer.putInt(0, 16);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.packetNumber = buffer.getLongUnsigned(32);
            int len = buffer.getIntUnsigned(16);
            byte[] packetData = new byte[len];
            if (len > 0) {
                this.packetContent = buffer.get(packetData);
            }
            this.setRtCode((byte)0);
        }
    }
}

