/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.dal.communication;

import com.fazecast.jSerialComm.SerialPort;
import com.fazecast.jSerialComm.SerialPortDataListener;
import com.fazecast.jSerialComm.SerialPortEvent;
import com.gg.reader.api.dal.communication.CommunicationInterface;
import com.gg.reader.api.dal.communication.HandlerDisconnected;
import com.gg.reader.api.protocol.gx.Message;
import java.net.Socket;

public class JSerialClient
extends CommunicationInterface {
    private SerialPort comPort;

    @Override
    public boolean open(String device_name, int port) {
        return false;
    }

    @Override
    public boolean open(Socket sConn) {
        return false;
    }

    @Override
    public boolean open(String device_name, int port, int timeout) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void triggerDisconnected() {
        block5: {
            try {
                if (this.onDisconnected == null) break block5;
                HandlerDisconnected handlerDisconnected = this.onDisconnected;
                synchronized (handlerDisconnected) {
                    this.onDisconnected.log();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean open(String param) {
        String[] split = param.split(":");
        if (split.length < 2) {
            return false;
        }
        this.comPort = SerialPort.getCommPort(split[0]);
        this.comPort.setBaudRate(Integer.parseInt(split[1]));
        this.comPort.setNumDataBits(8);
        this.comPort.setNumStopBits(1);
        this.comPort.setParity(0);
        boolean b = this.comPort.openPort();
        if (b) {
            this.keepReceived = true;
            this.startProcess();
        } else {
            this.close();
        }
        this.comPort.addDataListener(new SerialPortDataListener(){

            @Override
            public int getListeningEvents() {
                return 0x10000010;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void serialEvent(SerialPortEvent event) {
                try {
                    if (event.getEventType() == 0x10000000) {
                        JSerialClient.this.triggerDisconnected();
                        Thread.sleep(3000L);
                        return;
                    }
                    byte[] data = event.getReceivedData();
                    Object object = JSerialClient.this.lockRingBuffer;
                    synchronized (object) {
                        while (data.length + JSerialClient.this.ringBuffer.getDataCount() > 0x100000) {
                            JSerialClient.this.lockRingBuffer.wait(10000L);
                        }
                        JSerialClient.this.ringBuffer.WriteBuffer(data, 0, data.length);
                        JSerialClient.this.lockRingBuffer.notify();
                    }
                }
                catch (Exception ex) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        });
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.keepReceived = false;
            if (this.comPort != null) {
                this.comPort.removeDataListener();
                this.comPort.closePort();
                this.comPort = null;
            }
            Object object = this.lockRingBuffer;
            synchronized (object) {
                this.lockRingBuffer.notifyAll();
                this.ringBuffer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] data) {
        JSerialClient jSerialClient = this;
        synchronized (jSerialClient) {
            try {
                if (this.comPort != null) {
                    this.comPort.writeBytes(data, data.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void send(Message msg) {
        try {
            if (this.isRs485) {
                msg.msgType.mt_13 = "1";
                msg.rs485Address = this.getRs485Address();
            }
            msg.pack();
            this.send(msg.toBytes(this.isRs485));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int receive(byte[] buffer) {
        return 0;
    }

    @Override
    public boolean setBufferSize(int size) {
        return false;
    }

    @Override
    public void dispose() {
    }
}

