/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.PropertyPreFilter;
import java.util.HashSet;
import java.util.Set;

public class SimplePropertyPreFilter
implements PropertyPreFilter {
    private final Class<?> clazz;
    private final Set<String> includes = new HashSet<String>();
    private final Set<String> excludes = new HashSet<String>();

    public SimplePropertyPreFilter(String ... properties) {
        this((Class<?>)null, properties);
    }

    public SimplePropertyPreFilter(Class<?> clazz, String ... properties) {
        this.clazz = clazz;
        for (String item : properties) {
            if (item == null) continue;
            this.includes.add(item);
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public boolean apply(JSONSerializer serializer, Object source, String name) {
        if (source == null) {
            return true;
        }
        if (this.clazz != null && !this.clazz.isInstance(source)) {
            return true;
        }
        if (this.excludes.contains(name)) {
            return false;
        }
        return this.includes.size() == 0 || this.includes.contains(name);
    }
}

