/*
 * Decompiled with CFR 0.152.
 */
package com.hikvision.cms.api.common.util;

import com.hikvision.cms.api.common.util.Digests;
import com.hikvision.cms.api.common.util.JsonUtils;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;

public class HttpClientSSLUtils {
    private static HttpClient client = null;
    protected static final Integer DEFAULT_CONNECTION_TIME_OUT = 100000;
    protected static final Integer DEFAULT_SOCKET_TIME_OUT = 200000;
    protected static final String DEFAULT_CHAR_SET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, String jsonText) throws Exception {
        String string;
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        try {
            if (jsonText != null && !jsonText.isEmpty()) {
                StringEntity entity = new StringEntity(jsonText, ContentType.APPLICATION_JSON);
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(DEFAULT_CONNECTION_TIME_OUT.intValue());
            customReqConf.setSocketTimeout(DEFAULT_CONNECTION_TIME_OUT.intValue());
            post.setConfig(customReqConf.build());
            HttpResponse res = null;
            if (url.startsWith("https")) {
                client = HttpClientSSLUtils.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = HttpClientSSLUtils.client;
                res = client.execute((HttpUriRequest)post);
            }
            string = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)DEFAULT_CHAR_SET);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url) throws Exception {
        CloseableHttpClient client = null;
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            customReqConf.setConnectTimeout(DEFAULT_CONNECTION_TIME_OUT.intValue());
            customReqConf.setSocketTimeout(DEFAULT_CONNECTION_TIME_OUT.intValue());
            get.setConfig(customReqConf.build());
            HttpResponse res = null;
            if (url.startsWith("https")) {
                client = HttpClientSSLUtils.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)get);
            } else {
                client = HttpClientSSLUtils.client;
                res = client.execute((HttpUriRequest)get);
            }
            result = IOUtils.toString((InputStream)res.getEntity().getContent(), (String)DEFAULT_CHAR_SET);
        }
        catch (Throwable throwable) {
            get.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        get.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    public static void main(String[] args) {
        String url = "https://10.33.39.8/webapi/service/base/getPlatAuthSubSystemList";
        String params = "appkey=f8524632&time=" + System.currentTimeMillis() + "&pageNo=1&pageSize=10";
        String urlString = url + "?" + params + "&token=" + Digests.buildToken((String)(url + "?" + params), null, (String)"0a5a6558a06546088da645b5f9248a3a");
        try {
            String output = new String(HttpClientSSLUtils.doGet(urlString));
            System.out.println(output);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        url = "https://10.20.134.21/webapi/service/base/addPlatCard";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appkey", "f8524632");
        map.put("time", System.currentTimeMillis());
        map.put("startCardNo", "16000");
        map.put("endCardNo", "16010");
        params = JsonUtils.object2Json(map);
        url = url + "?token=" + Digests.buildToken((String)(url + "?" + params), null, (String)"0a5a6558a06546088da645b5f9248a3a");
        try {
            System.out.println(HttpClientSSLUtils.doPost(url, params));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(128);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
    }
}

