/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.asm;

import com.alibaba.fastjson.asm.ByteVector;
import com.alibaba.fastjson.asm.MethodWriter;

public class Label {
    static final int RESOLVED = 2;
    public Object info;
    int status;
    int line;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int inputStackTop;
    int outputStackMax;
    Label successor;
    Label next;

    void put(MethodWriter owner, ByteVector out, int source) {
        if ((this.status & 2) == 0) {
            this.addReference(source, out.length);
            out.putShort(-1);
        } else {
            out.putShort(this.position - source);
        }
    }

    private void addReference(int sourcePosition, int referencePosition) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] a = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, a, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = a;
        }
        this.srcAndRefPositions[this.referenceCount++] = sourcePosition;
        this.srcAndRefPositions[this.referenceCount++] = referencePosition;
    }

    void resolve(MethodWriter owner, int position, byte[] data) {
        this.status |= 2;
        this.position = position;
        int i = 0;
        while (i < this.referenceCount) {
            int source = this.srcAndRefPositions[i++];
            int reference = this.srcAndRefPositions[i++];
            int offset = position - source;
            data[reference++] = (byte)(offset >>> 8);
            data[reference] = (byte)offset;
        }
    }
}

