/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgTestAntConnectDetection
extends Message {
    private int thresholdValue = Integer.MAX_VALUE;
    private int antCount;
    private int status;

    public MsgTestAntConnectDetection() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0101";
            this.msgType.msgId = (byte)25;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgTestAntConnectDetection(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            while (buffer.position() / 8 < data.length) {
                byte pid = buffer.getByte();
                switch (pid) {
                    case 1: {
                        this.thresholdValue = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getThresholdValue() {
        return this.thresholdValue;
    }

    public void setThresholdValue(int thresholdValue) {
        this.thresholdValue = thresholdValue;
    }

    public int getAntCount() {
        return this.antCount;
    }

    public void setAntCount(int antCount) {
        this.antCount = antCount;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public StringBuilder toBinaryBuilder(int bitLen) {
        String s = Integer.toBinaryString(this.status);
        StringBuilder buffer = new StringBuilder(s);
        if (bitLen - s.length() > 0) {
            buffer.reverse();
            String format = String.format("%0" + (bitLen - s.length()) + "d", 0);
            buffer.append(format);
            buffer.reverse();
        }
        return buffer;
    }

    public StringBuilder toBinaryBuilder() {
        return this.toBinaryBuilder(this.antCount);
    }

    @Override
    public void pack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.thresholdValue) {
                buffer.putInt(1, 8);
                buffer.putInt(this.thresholdValue, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.thresholdValue) {
                buffer.putInt(1, 8);
                buffer.putInt(this.thresholdValue, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.antCount = buffer.getIntUnsigned(8);
            this.status = buffer.getIntUnsigned(32);
            this.setRtCode((byte)0);
        }
    }
}

