/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;

public class MsgBaseGetTagLog
extends Message {
    private int repeatedTime = Integer.MAX_VALUE;
    private int rssiTV = Integer.MAX_VALUE;

    public MsgBaseGetTagLog() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0010";
            this.msgType.msgId = (byte)10;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgBaseGetTagLog(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.repeatedTime = buffer.getIntUnsigned(16);
            this.rssiTV = buffer.getIntUnsigned(8);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRepeatedTime() {
        return this.repeatedTime;
    }

    public void setRepeatedTime(int repeatedTime) {
        this.repeatedTime = repeatedTime;
    }

    public int getRssiTV() {
        return this.rssiTV;
    }

    public void setRssiTV(int rssiTV) {
        this.rssiTV = rssiTV;
    }

    @Override
    public void pack() {
    }

    @Override
    public void ackPack() {
        try {
            BitBuffer buffer = BitBuffer.allocateDynamic();
            if (Integer.MAX_VALUE != this.repeatedTime) {
                buffer.putLong(this.repeatedTime, 16);
            }
            if (Integer.MAX_VALUE != this.rssiTV) {
                buffer.putLong(this.rssiTV, 8);
            }
            this.cData = buffer.asByteArray();
            this.dataLen = this.cData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void ackUnpack() {
        if (null != this.cData && this.cData.length > 0) {
            BitBuffer buffer = BitBuffer.wrap(this.cData);
            buffer.position(0);
            this.repeatedTime = buffer.getIntUnsigned(16);
            this.rssiTV = buffer.getIntUnsigned(8);
            this.setRtCode((byte)0);
        }
    }

    public String toString() {
        return "MsgBaseGetTagLog{repeatedTime=" + this.repeatedTime + ", rssiTV=" + this.rssiTV + '}';
    }
}

