/*
 * Decompiled with CFR 0.152.
 */
package com.gg.reader.api.protocol.gx;

import com.gg.reader.api.protocol.gx.Message;
import com.gg.reader.api.protocol.gx.MsgType;
import com.gg.reader.api.utils.BitBuffer;
import java.util.Hashtable;

public class MsgAppSetRs485
extends Message {
    private int address;
    private int baudRate = Integer.MAX_VALUE;

    public MsgAppSetRs485() {
        try {
            this.msgType = new MsgType();
            this.msgType.mt_8_11 = "0001";
            this.msgType.msgId = (byte)21;
            this.dataLen = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MsgAppSetRs485(byte[] data) {
        this();
        try {
            if (null == data || data.length <= 0) {
                return;
            }
            BitBuffer buffer = BitBuffer.wrap(data);
            buffer.position(0);
            this.address = buffer.getIntUnsigned(8);
            while (buffer.position() / 8 < data.length) {
                int pid = buffer.getIntUnsigned(8);
                switch (pid) {
                    case 1: {
                        this.baudRate = buffer.getIntUnsigned(8);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public void setBaudRate(int baudRate) {
        this.baudRate = baudRate;
    }

    @Override
    public void pack() {
        BitBuffer buffer = BitBuffer.allocateDynamic();
        buffer.put(this.address, 8);
        if (Integer.MAX_VALUE != this.baudRate) {
            buffer.putInt(1, 8);
            buffer.putLong(this.baudRate, 8);
        }
        this.cData = buffer.asByteArray();
        this.dataLen = this.cData.length;
    }

    @Override
    public void ackUnpack() {
        Hashtable<Byte, String> dicErrorMsg = new Hashtable<Byte, String>(){
            {
                this.put((byte)0, "Success.");
                this.put((byte)1, "Other error.");
            }
        };
        if (null != this.cData && this.cData.length == 1) {
            this.setRtCode(this.cData[0]);
            if (dicErrorMsg.containsKey(this.cData[0])) {
                this.setRtMsg((String)dicErrorMsg.get(this.cData[0]));
            }
        }
    }
}

