/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.env.input.server;

import com.alibaba.fastjson.JSONArray;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class EnvInputServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LogManager.getLogger(EnvInputServerHandler.class);
    private StringBuilder askTextSb = null;

    public void appendClientAsk(String text) {
        if (this.askTextSb == null) {
            this.askTextSb = new StringBuilder();
        }
        this.askTextSb.append(text);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf data = (ByteBuf)msg;
        String clientAskText = data.toString(CharsetUtil.UTF_8);
        this.appendClientAsk(clientAskText);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.askTextSb.toString().indexOf("end") != -1) {
            this.handleClientAskCmd(this.askTextSb.toString(), ctx);
            this.askTextSb.delete(0, this.askTextSb.length());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getMessage().indexOf("Connection reset") != -1) {
            log.info("\u76f8\u5173\u91c7\u96c6\u5668\u8bbe\u5907\u6b63\u5728\u91cd\u542f:" + cause.toString());
        }
        ctx.close();
    }

    private void handleClientAskCmd(String clientAskText, ChannelHandlerContext ctx) throws ParseException, IOException {
        clientAskText = clientAskText.replaceAll("\r", "").replaceAll("\n", "");
        JSONArray askJa = this.parseAskCmdPackage(clientAskText);
        for (int a = 0; a < askJa.size(); ++a) {
            String askText = askJa.getString(a);
            this.askCmdActuator(askText, ctx);
        }
    }

    private void askCmdActuator(String askText, ChannelHandlerContext ctx) throws ParseException, IOException {
        String cmd;
        System.out.println("======>\u63a5\u6536\u8bbe\u5907\u8bf7\u6c42:" + askText);
        String[] dataArray = askText.split("\\+");
        String cmdHeader = dataArray[0];
        if (!cmdHeader.trim().equalsIgnoreCase("hm")) {
            log.info("\u5f53\u524d\u547d\u4ee4\u662f\u975ehm\u547d\u4ee4[" + askText + "]");
            return;
        }
        switch (cmd = dataArray[1]) {
            case "1": {
                this.getTemp(dataArray, ctx);
                break;
            }
            case "2": {
                this.getChargingStatus(dataArray, ctx);
            }
            case "3": {
                this.getLeakageStatus(dataArray, ctx);
            }
            case "4": {
                this.getHear(dataArray, ctx);
            }
        }
    }

    private void getHear(String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+4+1+end";
        this.answerCmd(ans, ctx);
    }

    private void getLeakageStatus(String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+3+1+end";
        this.answerCmd(ans, ctx);
    }

    private void getChargingStatus(String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+2+1+end";
        this.answerCmd(ans, ctx);
    }

    private void getTemp(String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+1+1+end";
        this.answerCmd(ans, ctx);
    }

    public void answerCmd(String answerText, ChannelHandlerContext ctx) {
        log.info(String.format("\u5e94\u7b54\u6570\u636e--->%s", answerText));
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])answerText.getBytes()));
    }

    public boolean checkValidEarmark(String earmark) {
        return earmark.trim().equalsIgnoreCase("ffffffffffffffff") || earmark.trim().equalsIgnoreCase("0000000000000000");
    }

    public JSONArray parseAskCmdPackage(String text) {
        String key = "end";
        Pattern pattern = Pattern.compile(key);
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        JSONArray dataJa = new JSONArray();
        if (count == 1) {
            dataJa.add((Object)text);
        } else {
            for (int a = 0; a < count; ++a) {
                int p1 = text.indexOf("end");
                dataJa.add((Object)text.substring(0, p1 + 3));
                text = text.substring(p1 + 3, text.length());
            }
        }
        return dataJa;
    }
}

