/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.env.input.ws;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;

public class WebsocketWorkerUtil {
    private static final Map<Integer, List<Session>> SESSIONS = new ConcurrentHashMap();

    public static void addSession(Integer userId, Session session) {
        ArrayList<Session> sessions = (ArrayList<Session>)SESSIONS.get(userId);
        if (sessions == null) {
            sessions = new ArrayList<Session>();
        }
        sessions.add(session);
        SESSIONS.putIfAbsent(userId, sessions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSession(Integer userId) {
        Map map = SESSIONS;
        synchronized (map) {
            List sessions = (List)SESSIONS.get(userId);
            if (sessions == null) {
                return;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < sessions.size(); ++i) {
                Session session = (Session)sessions.get(i);
                try {
                    if (session.isOpen()) continue;
                    list.add(i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sessions.remove(session);
                }
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sessions.remove(i);
            }
        }
    }

    public static void sendMessage(Session session, String msg) {
        if (session == null) {
            return;
        }
        RemoteEndpoint.Async async = session.getAsyncRemote();
        async.sendText(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sendWarningMessage(Integer farmId, String msg) {
        Map map = SESSIONS;
        synchronized (map) {
            List sessions = (List)SESSIONS.get(farmId);
            if (sessions == null) {
                return;
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < sessions.size(); ++i) {
                Session session = (Session)sessions.get(i);
                try {
                    if (session.isOpen()) {
                        session.getBasicRemote().sendText(msg);
                        continue;
                    }
                    list.add(i);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    sessions.remove(session);
                }
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                sessions.remove(i);
            }
        }
    }
}

