/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.env.input.server;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.huimv.env.input.c.MyNativeClass;
import com.huimv.env.input.config.WeChatMessage;
import com.huimv.env.input.config.WeChatMessage2;
import com.huimv.env.input.entity.BaseFarm;
import com.huimv.env.input.entity.BasePigpen;
import com.huimv.env.input.entity.EnvData;
import com.huimv.env.input.entity.Gateway;
import com.huimv.env.input.entity.HeartInfo;
import com.huimv.env.input.entity.PortChangeData;
import com.huimv.env.input.entity.PortWarningInfo;
import com.huimv.env.input.entity.SysAccountMultilevel;
import com.huimv.env.input.entity.Terminal;
import com.huimv.env.input.entity.TerminalPort;
import com.huimv.env.input.entity.vo.AlarmInfoVO;
import com.huimv.env.input.service.IBaseFarmService;
import com.huimv.env.input.service.IBasePigpenService;
import com.huimv.env.input.service.IEnvDataService;
import com.huimv.env.input.service.IGatewayService;
import com.huimv.env.input.service.IHeartInfoService;
import com.huimv.env.input.service.IPortChangeDataService;
import com.huimv.env.input.service.IPortWarningInfoService;
import com.huimv.env.input.service.ISysAccountMultilevelService;
import com.huimv.env.input.service.ITerminalPortService;
import com.huimv.env.input.service.ITerminalService;
import com.huimv.env.input.utils.ElePostUtils;
import com.huimv.env.input.ws.WebsocketWorkerUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.CharsetUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@ChannelHandler.Sharable
@Component
public class EnvInputServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LogManager.getLogger(EnvInputServerHandler.class);
    private StringBuilder askTextSb = null;
    @Autowired
    private IEnvDataService envDataService;
    @Autowired
    private ITerminalPortService terminalPortService;
    @Autowired
    private IBaseFarmService baseFarmService;
    @Autowired
    private IBasePigpenService basePigpenService;
    @Autowired
    private IPortWarningInfoService portWarningInfoService;
    @Autowired
    private IPortChangeDataService portChangeDataService;
    @Autowired
    private ITerminalService terminalService;
    @Autowired
    private IHeartInfoService heartInfoService;
    @Autowired
    private IGatewayService gatewayService;
    @Autowired
    private ISysAccountMultilevelService sysAccountMultilevelService;

    public void appendClientAsk(String text) {
        if (this.askTextSb == null) {
            this.askTextSb = new StringBuilder();
        }
        this.askTextSb.append(text);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf data = (ByteBuf)msg;
        String clientAskText = data.toString(CharsetUtil.UTF_8);
        this.appendClientAsk(clientAskText);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.askTextSb.toString().indexOf("end") != -1) {
            this.handleClientAskCmd(this.askTextSb.toString(), ctx);
            this.askTextSb.delete(0, this.askTextSb.length());
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getMessage().indexOf("Connection reset") != -1) {
            log.info("\u76f8\u5173\u91c7\u96c6\u5668\u8bbe\u5907\u6b63\u5728\u91cd\u542f:" + cause.toString());
        }
        ctx.close();
    }

    private void handleClientAskCmd(String clientAskText, ChannelHandlerContext ctx) throws IOException {
        clientAskText = clientAskText.replaceAll("\r", "").replaceAll("\n", "");
        JSONArray askJa = this.parseAskCmdPackage(clientAskText);
        for (int a = 0; a < askJa.size(); ++a) {
            String askText = askJa.getString(a);
            this.askCmdActuator(askText, ctx);
        }
    }

    private void askCmdActuator(String askText, ChannelHandlerContext ctx) throws IOException {
        System.out.println("======>\u63a5\u6536\u8bbe\u5907\u8bf7\u6c42:" + askText);
        String[] dataArray = askText.split("\\+");
        String cmdHeader = dataArray[0];
        if (!cmdHeader.trim().equalsIgnoreCase("hm")) {
            log.info("\u5f53\u524d\u547d\u4ee4\u662f\u975ehm\u547d\u4ee4[" + askText + "]");
            return;
        }
        String version = dataArray[dataArray.length - 3];
        if ("v2.0".equals(version)) {
            this.askCmdActuatorV2(askText, ctx, dataArray);
        } else {
            this.askCmdActuatorV1(askText, ctx, dataArray);
        }
    }

    private void askCmdActuatorV2(String askText, ChannelHandlerContext ctx, String[] dataArray) throws IOException {
        String cmd;
        switch (cmd = dataArray[1]) {
            case "1": {
                this.getHear(askText, dataArray, ctx, 2);
                break;
            }
            case "2": {
                this.getChuanGanData2(askText, dataArray, ctx);
                break;
            }
            case "3": {
                this.savePower2(askText, dataArray, ctx);
                break;
            }
            case "4": {
                this.saveElectric2(askText, dataArray, ctx);
                break;
            }
            case "5": {
                this.saveBeforeElectric2(askText, dataArray, ctx);
                break;
            }
            default: {
                log.error(String.format("\u672a\u77e5\u6307\u4ee4 --> %s", askText));
                this.answerCmd("hm+4+1+end", ctx);
            }
        }
    }

    private synchronized void saveBeforeElectric2(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = "1";
        String num = dataArray[4];
        String eleData = dataArray[5];
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData();
                portChangeData.setNum(Integer.valueOf(Integer.parseInt(num)));
                portChangeData.setCreateTime(now);
                portChangeData.setGatwayCode(gateWayCode);
                portChangeData.setTerminalCode(gateWayCode + terminalCode);
                portChangeData.setTerminalPortCode(gateWayCode + terminalCode + terminalPortCode);
                portChangeData.setBeforeElectricCurrent(eleData);
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setBeforeElectricCurrent(eleData);
                this.portChangeDataService.updateById((Object)portChangeData);
                if (this.changeDataIsAll(portChangeData)) {
                    int i = this.getStatusEle2(portChangeData);
                    TerminalPort deviceCode = (TerminalPort)this.terminalPortService.getOne((Wrapper)new QueryWrapper().eq((Object)"device_code", (Object)portChangeData.getTerminalPortCode()));
                    System.out.println("---->" + i);
                    if (i == 1) {
                        deviceCode.setChargingWarning(Integer.valueOf(1));
                        String ans = "hm+5+1+end";
                        this.answerCmd(ans, ctx);
                        this.saveChargingWarning(portChangeData, deviceCode);
                        EnvData envData = new EnvData();
                        envData.setActivePower(portChangeData.getActivePower());
                        this.pushAlarm(terminalCode + terminalPortCode, Integer.valueOf(12), envData);
                    } else {
                        String ans = "hm+5+0+end";
                        this.answerCmd(ans, ctx);
                        deviceCode.setChargingWarning(Integer.valueOf(0));
                    }
                    this.terminalPortService.updateById((Object)deviceCode);
                }
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    private int getStatusEle2(PortChangeData portChangeData) {
        String[] lastEleData = portChangeData.getBeforeElectricCurrent().split(",");
        String[] lastGlData = new String[]{String.valueOf(portChangeData.getBeforeActivePower()), String.valueOf(portChangeData.getBeforeReactivePower()), String.valueOf(portChangeData.getBeforeApparentPower())};
        String[] curretEleData = portChangeData.getElectricCurrent().split(",");
        String[] curretGlData = new String[]{String.valueOf(portChangeData.getActivePower()), String.valueOf(portChangeData.getReactivePower()), String.valueOf(portChangeData.getApparentPower())};
        Object[] ints = Stream.concat(Arrays.stream(lastGlData), Arrays.stream(lastEleData)).toArray();
        Object[] ints1 = Stream.concat(Arrays.stream(curretGlData), Arrays.stream(curretEleData)).toArray();
        return this.add2(ints, ints1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int add2(Object[] array1, Object[] array2) {
        String tempInputFile = "temp_input.txt";
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(tempInputFile));){
            String array1String = Arrays.stream(array1).map(Object::toString).collect(Collectors.joining(","));
            writer.write(array1String);
            writer.newLine();
            String array2String = Arrays.stream(array2).map(Object::toString).collect(Collectors.joining(","));
            writer.write(array2String);
            writer.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        String cProgramPath = "/root/svm_detection_c/predict";
        String tempOutputFile = "temp_output.txt";
        ProcessBuilder processBuilder = new ProcessBuilder(cProgramPath, tempInputFile, tempOutputFile);
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                System.err.println("C program execution failed with exit code: " + exitCode);
                return 0;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            return 0;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(tempOutputFile));){
            String line;
            String str = "1";
            while ((line = reader.readLine()) != null) {
                System.out.println("line" + line);
                str = line;
            }
            int n = Integer.parseInt(str);
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private synchronized void saveElectric2(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+4+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = "1";
        String num = dataArray[4];
        String eleData = dataArray[5];
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData();
                portChangeData.setNum(Integer.valueOf(Integer.parseInt(num)));
                portChangeData.setCreateTime(now);
                portChangeData.setGatwayCode(gateWayCode);
                portChangeData.setTerminalCode(gateWayCode + terminalCode);
                portChangeData.setTerminalPortCode(gateWayCode + terminalCode + terminalPortCode);
                portChangeData.setElectricCurrent(eleData);
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setElectricCurrent(eleData);
                this.portChangeDataService.updateById((Object)portChangeData);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    private synchronized void savePower2(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+3+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = "1";
        String num = dataArray[4];
        int[] splitPower = Arrays.stream(dataArray[5].split(",")).mapToInt(Integer::parseInt).toArray();
        int[] splitBeforePower = Arrays.stream(dataArray[6].split(",")).mapToInt(Integer::parseInt).toArray();
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData(gateWayCode + terminalCode + terminalPortCode, gateWayCode + terminalCode, gateWayCode, Integer.valueOf(splitPower[0]), Integer.valueOf(splitPower[1]), Integer.valueOf(splitPower[2]), Integer.valueOf(splitBeforePower[0]), Integer.valueOf(splitBeforePower[1]), Integer.valueOf(splitBeforePower[2]), now, Integer.valueOf(Integer.parseInt(num)));
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setActivePower(Integer.valueOf(splitPower[0]));
                portChangeData.setReactivePower(Integer.valueOf(splitPower[1]));
                portChangeData.setApparentPower(Integer.valueOf(splitPower[2]));
                portChangeData.setBeforeActivePower(Integer.valueOf(splitBeforePower[0]));
                portChangeData.setBeforeReactivePower(Integer.valueOf(splitBeforePower[1]));
                portChangeData.setBeforeApparentPower(Integer.valueOf(splitBeforePower[2]));
                this.portChangeDataService.updateById((Object)portChangeData);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    private int getStatusEle(PortChangeData portChangeData) {
        int[] lastEleData = Arrays.stream(portChangeData.getBeforeElectricCurrent().split(",")).mapToInt(Integer::parseInt).toArray();
        int[] lastGlData = new int[]{portChangeData.getBeforeActivePower(), portChangeData.getBeforeReactivePower(), portChangeData.getBeforeApparentPower()};
        int[] curretEleData = Arrays.stream(portChangeData.getElectricCurrent().split(",")).mapToInt(Integer::parseInt).toArray();
        int[] curretGlData = new int[]{portChangeData.getActivePower(), portChangeData.getReactivePower(), portChangeData.getApparentPower()};
        int[] ints = IntStream.concat(Arrays.stream(lastGlData), Arrays.stream(lastEleData)).toArray();
        int[] ints1 = IntStream.concat(Arrays.stream(curretGlData), Arrays.stream(curretEleData)).toArray();
        System.out.println("last");
        for (int i : ints) {
            System.out.print(i + ",");
        }
        System.out.println();
        System.out.println("curretData");
        for (int i : ints1) {
            System.out.print(i + ",");
        }
        System.out.println();
        return MyNativeClass.LibraryshowChar.LIBRARY_CHAR.current_detection(ints, ints1);
    }

    private void saveChargingWarning(PortChangeData portChangeData, TerminalPort deviceCode) {
        BasePigpen basePigpen = (BasePigpen)this.basePigpenService.getById((Serializable)deviceCode.getLocationId());
        BasePigpen basePigpen1 = (BasePigpen)this.basePigpenService.getById((Serializable)((Object)basePigpen.getOther2().split(",")[1]));
        PortWarningInfo portWarningInfo = new PortWarningInfo();
        portWarningInfo.setGatwayCode(portChangeData.getGatwayCode());
        portWarningInfo.setTerminalCode(portChangeData.getTerminalCode());
        portWarningInfo.setTerminalPortCode(portChangeData.getTerminalPortCode());
        portWarningInfo.setLocationId(deviceCode.getLocationId());
        portWarningInfo.setFarmId(deviceCode.getFarmId());
        portWarningInfo.setWarningType(Integer.valueOf(2));
        Date now = new Date();
        portWarningInfo.setCreateTime(now);
        portWarningInfo.setContent(String.format("%s \u5145\u7535\u9884\u8b66", basePigpen.getBuildName()));
        portWarningInfo.setWarningType(Integer.valueOf(2));
        this.portWarningInfoService.save((Object)portWarningInfo);
        List list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)deviceCode.getFarmId())).eq((Object)"subscribe", (Object)1));
        for (SysAccountMultilevel sysAccountMultilevel : list) {
            WeChatMessage.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
            WeChatMessage2.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
            sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
            this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
        }
        WebsocketWorkerUtil.sendWarningMessage((Integer)deviceCode.getFarmId(), (String)String.format("%s \u5145\u7535\u9884\u8b66", basePigpen.getBuildName()));
    }

    private boolean changeDataIsAll(PortChangeData portChangeData) {
        return portChangeData.getActivePower() != null && portChangeData.getBeforeActivePower() != null && portChangeData.getReactivePower() != null && portChangeData.getBeforeReactivePower() != null && portChangeData.getApparentPower() != null && portChangeData.getBeforeApparentPower() != null && portChangeData.getElectricCurrent() != null && portChangeData.getBeforeElectricCurrent() != null;
    }

    private void getChuanGanData2(String askText, String[] dataArray, ChannelHandlerContext ctx) throws IOException {
        String ans = "hm+2+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = "1";
        String voltage = this.getNum(dataArray[4]);
        String electriCurrent = this.getNum(dataArray[5]);
        String temp = this.getNum(dataArray[6]);
        String leakageValue = this.getNum(dataArray[7]);
        Date now = new Date();
        int[] splitPower = Arrays.stream(dataArray[8].split(",")).mapToInt(Integer::parseInt).toArray();
        int[] splitStatus = Arrays.stream(dataArray[9].split(",")).mapToInt(Integer::parseInt).toArray();
        EnvData envData = new EnvData(gateWayCode + terminalCode + terminalPortCode, gateWayCode + terminalCode, gateWayCode, voltage, electriCurrent, temp, leakageValue, Integer.valueOf(splitPower[0]), Integer.valueOf(splitPower[1]), Integer.valueOf(splitPower[2]), splitStatus[0], 0, splitStatus[1], askText, now);
        this.envDataService.save((Object)envData);
        TerminalPort deviceCode = (TerminalPort)this.terminalPortService.getOne((Wrapper)new QueryWrapper().eq((Object)"device_code", (Object)(gateWayCode + terminalCode + terminalPortCode)));
        if (ObjectUtils.isEmpty((Object)deviceCode)) {
            log.info(String.format("\u65e0\u7aef\u53e3\u8bbe\u5907--> %s", askText));
            return;
        }
        deviceCode.setVoltage(voltage);
        deviceCode.setElectricCurrent(electriCurrent);
        deviceCode.setTemp(temp);
        deviceCode.setLeakageValue(leakageValue);
        deviceCode.setActivePower(Integer.valueOf(splitPower[0]));
        deviceCode.setReactivePower(Integer.valueOf(splitPower[1]));
        deviceCode.setApparentPower(Integer.valueOf(splitPower[2]));
        deviceCode.setHeightTempWarning(Integer.valueOf(splitStatus[0]));
        deviceCode.setChargingWarning(Integer.valueOf(0));
        deviceCode.setLeakageWarning(Integer.valueOf(splitStatus[1]));
        deviceCode.setUpdateTime(now);
        deviceCode.setStatus(Integer.valueOf(1));
        this.terminalPortService.updateById((Object)deviceCode);
        this.saveWarning2(gateWayCode, terminalCode, terminalPortCode, deviceCode, splitStatus, now, envData);
    }

    private void saveWarning2(String gateWayCode, String terminaCode, String terminalPortCode, TerminalPort terminalPort, int[] splitStatus, Date now, EnvData envData) throws IOException {
        List list;
        if (splitStatus[0] == 0 && splitStatus[1] == 0) {
            return;
        }
        Integer farmId = terminalPort.getFarmId();
        Integer locationId = terminalPort.getLocationId();
        BasePigpen basePigpen = (BasePigpen)this.basePigpenService.getById((Serializable)locationId);
        BasePigpen basePigpen1 = (BasePigpen)this.basePigpenService.getById((Serializable)((Object)basePigpen.getOther2().split(",")[1]));
        if (ObjectUtils.isEmpty((Object)basePigpen)) {
            log.info(String.format("\u65e0\u680b\u820d\u6570\u636e--> %s", terminalPort.toString()));
            return;
        }
        PortWarningInfo portWarningInfo = new PortWarningInfo();
        portWarningInfo.setGatwayCode(gateWayCode);
        portWarningInfo.setTerminalCode(gateWayCode + terminaCode);
        portWarningInfo.setTerminalPortCode(gateWayCode + terminaCode + terminalPortCode);
        portWarningInfo.setLocationId(locationId);
        portWarningInfo.setFarmId(farmId);
        portWarningInfo.setWarningType(farmId);
        portWarningInfo.setCreateTime(now);
        if (splitStatus[0] == 1) {
            portWarningInfo.setContent(String.format("%s \u9ad8\u6e29\u9884\u8b66", basePigpen.getBuildName()));
            portWarningInfo.setWarningType(Integer.valueOf(1));
            this.portWarningInfoService.save((Object)portWarningInfo);
            list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)farmId)).eq((Object)"subscribe", (Object)1));
            for (SysAccountMultilevel sysAccountMultilevel : list) {
                WeChatMessage.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                WeChatMessage2.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
                this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
            }
            WebsocketWorkerUtil.sendWarningMessage((Integer)farmId, (String)String.format("%s \u9ad8\u6e29\u9884\u8b66", basePigpen.getBuildName()));
            this.pushAlarm(terminaCode + terminalPortCode, Integer.valueOf(2), envData);
        }
        if (splitStatus[1] == 1) {
            portWarningInfo.setContent(String.format("%s \u6f0f\u7535\u9884\u8b66", basePigpen.getBuildName()));
            portWarningInfo.setWarningType(Integer.valueOf(3));
            this.portWarningInfoService.save((Object)portWarningInfo);
            list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)farmId)).eq((Object)"subscribe", (Object)1));
            for (SysAccountMultilevel sysAccountMultilevel : list) {
                WeChatMessage.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                WeChatMessage2.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
                this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
            }
            WebsocketWorkerUtil.sendWarningMessage((Integer)farmId, (String)String.format("%s \u6f0f\u7535\u9884\u8b66", basePigpen.getBuildName()));
            this.pushAlarm(terminaCode + terminalPortCode, Integer.valueOf(1), envData);
        }
    }

    private void askCmdActuatorV1(String askText, ChannelHandlerContext ctx, String[] dataArray) throws IOException {
        String cmd;
        switch (cmd = dataArray[1]) {
            case "1": {
                this.getHear(askText, dataArray, ctx, 1);
                break;
            }
            case "2": {
                this.getChuanGanData(askText, dataArray, ctx);
                break;
            }
            case "3": {
                this.savePower(askText, dataArray, ctx);
                break;
            }
            case "4": {
                this.saveElectric(askText, dataArray, ctx);
                break;
            }
            case "5": {
                this.saveBeforeElectric(askText, dataArray, ctx);
                break;
            }
            default: {
                log.error(String.format("\u672a\u77e5\u6307\u4ee4 --> %s", askText));
                this.answerCmd("hm+4+1+end", ctx);
            }
        }
    }

    private synchronized void saveBeforeElectric(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+5+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = dataArray[4];
        String num = dataArray[5];
        String eleData = dataArray[6];
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData();
                portChangeData.setNum(Integer.valueOf(Integer.parseInt(num)));
                portChangeData.setCreateTime(now);
                portChangeData.setGatwayCode(gateWayCode);
                portChangeData.setTerminalCode(gateWayCode + terminalCode);
                portChangeData.setTerminalPortCode(gateWayCode + terminalCode + terminalPortCode);
                portChangeData.setBeforeElectricCurrent(eleData);
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setBeforeElectricCurrent(eleData);
                this.portChangeDataService.updateById((Object)portChangeData);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    private synchronized void saveElectric(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+4+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = dataArray[4];
        String num = dataArray[5];
        String eleData = dataArray[6];
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData();
                portChangeData.setNum(Integer.valueOf(Integer.parseInt(num)));
                portChangeData.setCreateTime(now);
                portChangeData.setGatwayCode(gateWayCode);
                portChangeData.setTerminalCode(gateWayCode + terminalCode);
                portChangeData.setTerminalPortCode(gateWayCode + terminalCode + terminalPortCode);
                portChangeData.setElectricCurrent(eleData);
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setElectricCurrent(eleData);
                this.portChangeDataService.updateById((Object)portChangeData);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    public String reverseWithComma(String input) {
        String[] parts = input.split(",");
        List<String> partList = Arrays.asList(parts);
        Collections.reverse(partList);
        StringBuilder reversedBuilder = new StringBuilder();
        for (int i = 0; i < partList.size(); ++i) {
            reversedBuilder.append(partList.get(i));
            if (i >= partList.size() - 1) continue;
            reversedBuilder.append(",");
        }
        return reversedBuilder.toString();
    }

    private synchronized void savePower(String askText, String[] dataArray, ChannelHandlerContext ctx) {
        String ans = "hm+3+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = dataArray[4];
        String num = dataArray[5];
        int[] splitPower = Arrays.stream(dataArray[6].split(",")).mapToInt(Integer::parseInt).toArray();
        int[] splitBeforePower = Arrays.stream(dataArray[7].split(",")).mapToInt(Integer::parseInt).toArray();
        Date now = new Date();
        try {
            PortChangeData portChangeData = (PortChangeData)this.portChangeDataService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"terminal_port_code", (Object)(gateWayCode + terminalCode + terminalPortCode))).eq((Object)"num", (Object)num));
            if (ObjectUtils.isEmpty((Object)portChangeData)) {
                portChangeData = new PortChangeData(gateWayCode + terminalCode + terminalPortCode, gateWayCode + terminalCode, gateWayCode, Integer.valueOf(splitPower[0]), Integer.valueOf(splitPower[1]), Integer.valueOf(splitPower[2]), Integer.valueOf(splitBeforePower[0]), Integer.valueOf(splitBeforePower[1]), Integer.valueOf(splitBeforePower[2]), now, Integer.valueOf(Integer.parseInt(num)));
                this.portChangeDataService.save((Object)portChangeData);
            } else {
                portChangeData.setActivePower(Integer.valueOf(splitPower[0]));
                portChangeData.setReactivePower(Integer.valueOf(splitPower[1]));
                portChangeData.setApparentPower(Integer.valueOf(splitPower[2]));
                portChangeData.setBeforeActivePower(Integer.valueOf(splitBeforePower[0]));
                portChangeData.setBeforeReactivePower(Integer.valueOf(splitBeforePower[1]));
                portChangeData.setBeforeApparentPower(Integer.valueOf(splitBeforePower[2]));
                this.portChangeDataService.updateById((Object)portChangeData);
            }
        }
        catch (Exception e) {
            log.error(String.format("\u70b9\u4f4d\u67e5\u8be2\u5931\u8d25--> %s", askText));
            log.error((Object)e);
        }
    }

    private void getHear(String askText, String[] dataArray, ChannelHandlerContext ctx, int version) throws IOException {
        String ans = "hm+1+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = version == 1 ? dataArray[3] : "1";
        TerminalPort terminalPort = new TerminalPort();
        terminalPort.setStatus(Integer.valueOf(1));
        this.terminalPortService.update((Object)terminalPort, (Wrapper)new UpdateWrapper().like((Object)"device_code", (Object)(gateWayCode + terminalCode)));
        Terminal terminal = new Terminal();
        terminal.setStatus(Integer.valueOf(1));
        this.terminalService.update((Object)terminal, (Wrapper)new UpdateWrapper().eq((Object)"device_code", (Object)(gateWayCode + terminalCode)));
        Gateway gateway = new Gateway();
        gateway.setStatus(Integer.valueOf(1));
        this.gatewayService.update((Object)gateway, (Wrapper)new UpdateWrapper().eq((Object)"device_code", (Object)gateWayCode));
        HeartInfo heartInfo1 = new HeartInfo(new Date(), gateWayCode + terminalCode, gateWayCode, askText);
        this.heartInfoService.save((Object)heartInfo1);
    }

    private void getChuanGanData(String askText, String[] dataArray, ChannelHandlerContext ctx) throws IOException {
        String ans = "hm+2+1+end";
        this.answerCmd(ans, ctx);
        String gateWayCode = dataArray[2];
        String terminalCode = dataArray[3];
        String terminalPortCode = dataArray[4];
        String voltage = this.getNum(dataArray[5]);
        String electriCurrent = this.getNum(dataArray[6]);
        String temp = this.getNum(dataArray[7]);
        String leakageValue = this.getNum(dataArray[8]);
        Date now = new Date();
        int[] splitPower = Arrays.stream(dataArray[9].split(",")).mapToInt(Integer::parseInt).toArray();
        int[] splitStatus = Arrays.stream(dataArray[10].split(",")).mapToInt(Integer::parseInt).toArray();
        EnvData envData = new EnvData(gateWayCode + terminalCode + terminalPortCode, gateWayCode + terminalCode, gateWayCode, voltage, electriCurrent, temp, leakageValue, Integer.valueOf(splitPower[0]), Integer.valueOf(splitPower[1]), Integer.valueOf(splitPower[2]), splitStatus[0], splitStatus[1], splitStatus[2], askText, now);
        this.envDataService.save((Object)envData);
        TerminalPort deviceCode = (TerminalPort)this.terminalPortService.getOne((Wrapper)new QueryWrapper().eq((Object)"device_code", (Object)(gateWayCode + terminalCode + terminalPortCode)));
        if (ObjectUtils.isEmpty((Object)deviceCode)) {
            log.info(String.format("\u65e0\u7aef\u53e3\u8bbe\u5907--> %s", askText));
            return;
        }
        deviceCode.setVoltage(voltage);
        deviceCode.setElectricCurrent(electriCurrent);
        deviceCode.setTemp(temp);
        deviceCode.setLeakageValue(leakageValue);
        deviceCode.setActivePower(Integer.valueOf(splitPower[0]));
        deviceCode.setReactivePower(Integer.valueOf(splitPower[1]));
        deviceCode.setApparentPower(Integer.valueOf(splitPower[2]));
        deviceCode.setHeightTempWarning(Integer.valueOf(splitStatus[0]));
        deviceCode.setChargingWarning(Integer.valueOf(splitStatus[1]));
        deviceCode.setLeakageWarning(Integer.valueOf(splitStatus[2]));
        deviceCode.setUpdateTime(now);
        deviceCode.setStatus(Integer.valueOf(1));
        this.terminalPortService.updateById((Object)deviceCode);
        this.saveWarning(gateWayCode, terminalCode, terminalPortCode, deviceCode, splitStatus, now, envData);
    }

    private void saveWarning(String gateWayCode, String terminaCode, String terminalPortCode, TerminalPort terminalPort, int[] splitStatus, Date now, EnvData envData) throws IOException {
        List list;
        if (splitStatus[0] == 0 && splitStatus[1] == 0 && splitStatus[2] == 0) {
            return;
        }
        Integer farmId = terminalPort.getFarmId();
        Integer locationId = terminalPort.getLocationId();
        BaseFarm baseFarm = (BaseFarm)this.baseFarmService.getById((Serializable)farmId);
        BasePigpen basePigpen = (BasePigpen)this.basePigpenService.getById((Serializable)locationId);
        if (ObjectUtils.isEmpty((Object)baseFarm)) {
            log.info(String.format("\u65e0\u5c0f\u533a\u6570\u636e--> %s", terminalPort.toString()));
            return;
        }
        if (ObjectUtils.isEmpty((Object)basePigpen)) {
            log.info(String.format("\u65e0\u680b\u820d\u6570\u636e--> %s", terminalPort.toString()));
            return;
        }
        BasePigpen basePigpen1 = (BasePigpen)this.basePigpenService.getById((Serializable)((Object)basePigpen.getOther2().split(",")[1]));
        PortWarningInfo portWarningInfo = new PortWarningInfo();
        portWarningInfo.setGatwayCode(gateWayCode);
        portWarningInfo.setTerminalCode(gateWayCode + terminaCode);
        portWarningInfo.setTerminalPortCode(gateWayCode + terminaCode + terminalPortCode);
        portWarningInfo.setLocationId(locationId);
        portWarningInfo.setFarmId(farmId);
        portWarningInfo.setWarningType(Integer.valueOf(1));
        portWarningInfo.setCreateTime(now);
        if (splitStatus[0] == 1) {
            portWarningInfo.setContent(String.format("%s \u9ad8\u6e29\u9884\u8b66", basePigpen.getBuildName()));
            portWarningInfo.setWarningType(Integer.valueOf(1));
            this.portWarningInfoService.save((Object)portWarningInfo);
            list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)farmId)).eq((Object)"subscribe", (Object)1));
            for (SysAccountMultilevel sysAccountMultilevel : list) {
                WeChatMessage.sendMsg((Date)now, (String)"\u9ad8\u6e29\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                WeChatMessage2.sendMsg((Date)now, (String)"\u9ad8\u6e29\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
                this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
            }
            WebsocketWorkerUtil.sendWarningMessage((Integer)farmId, (String)String.format("%s \u9ad8\u6e29\u9884\u8b66", basePigpen.getBuildName()));
            this.pushAlarm(terminaCode + terminalPortCode, Integer.valueOf(2), envData);
        }
        if (splitStatus[1] == 1) {
            portWarningInfo.setContent(String.format("%s \u5145\u7535\u9884\u8b66", basePigpen.getBuildName()));
            portWarningInfo.setWarningType(Integer.valueOf(2));
            this.portWarningInfoService.save((Object)portWarningInfo);
            list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)farmId)).eq((Object)"subscribe", (Object)1));
            for (SysAccountMultilevel sysAccountMultilevel : list) {
                WeChatMessage.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                WeChatMessage2.sendMsg((Date)now, (String)"\u5145\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
                this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
            }
            WebsocketWorkerUtil.sendWarningMessage((Integer)farmId, (String)String.format("%s \u5145\u7535\u9884\u8b66", basePigpen.getBuildName()));
            this.pushAlarm(terminaCode + terminalPortCode, Integer.valueOf(12), envData);
        }
        if (splitStatus[2] == 1) {
            portWarningInfo.setContent(String.format("%s \u6f0f\u7535\u9884\u8b66", basePigpen.getBuildName()));
            portWarningInfo.setWarningType(Integer.valueOf(3));
            this.portWarningInfoService.save((Object)portWarningInfo);
            list = this.sysAccountMultilevelService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"last_farm_id", (Object)farmId)).eq((Object)"subscribe", (Object)1));
            for (SysAccountMultilevel sysAccountMultilevel : list) {
                WeChatMessage.sendMsg((Date)now, (String)"\u6f0f\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                WeChatMessage2.sendMsg((Date)now, (String)"\u6f0f\u7535\u9884\u8b66", (String)basePigpen1.getBuildName(), (String)basePigpen.getBuildName().substring(basePigpen1.getBuildName().length()), (String)sysAccountMultilevel.getWechatId());
                sysAccountMultilevel.setSubscribe(Integer.valueOf(0));
                this.sysAccountMultilevelService.updateById((Object)sysAccountMultilevel);
            }
            WebsocketWorkerUtil.sendWarningMessage((Integer)farmId, (String)String.format("%s \u6f0f\u7535\u9884\u8b66", basePigpen.getBuildName()));
            this.pushAlarm(terminaCode + terminalPortCode, Integer.valueOf(1), envData);
        }
    }

    private void pushAlarm(String deviceId, Integer errorCode, EnvData envData) throws IOException {
        AlarmInfoVO alarmInfoVO = new AlarmInfoVO();
        alarmInfoVO.setDevice_id(deviceId);
        alarmInfoVO.setError_code(errorCode);
        switch (errorCode) {
            case 2: {
                alarmInfoVO.setError_value(envData.getTemp());
                break;
            }
            case 1: {
                alarmInfoVO.setError_value(envData.getLeakageValue());
                break;
            }
            default: {
                System.out.println("\u5145\u7535\u62a5\u8b66");
            }
        }
        alarmInfoVO.setFrequency(Integer.valueOf(50));
        alarmInfoVO.setLeakage(envData.getLeakageValue());
        alarmInfoVO.setVolt_a(envData.getVoltage());
        alarmInfoVO.setCurr_a(envData.getElectricCurrent());
        alarmInfoVO.setTemp_a(envData.getTemp());
        alarmInfoVO.setPower_a(envData.getActivePower());
        ArrayList<AlarmInfoVO> list1 = new ArrayList<AlarmInfoVO>();
        list1.add(alarmInfoVO);
        ElePostUtils.heartPost((String)"https://south.bowaniot.com/airswitch/message/elec/alarm/import", (String)envData.getGatwayCode(), list1);
    }

    private String getNum(String num) {
        return String.format("%.1f", Double.parseDouble(num) / 10.0);
    }

    public void answerCmd(String answerText, ChannelHandlerContext ctx) {
        log.info(String.format("\u5e94\u7b54\u6570\u636e--->%s", answerText));
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])answerText.getBytes()));
    }

    public boolean checkValidEarmark(String earmark) {
        return earmark.trim().equalsIgnoreCase("ffffffffffffffff") || earmark.trim().equalsIgnoreCase("0000000000000000");
    }

    public JSONArray parseAskCmdPackage(String text) {
        String key = "end";
        Pattern pattern = Pattern.compile(key);
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        JSONArray dataJa = new JSONArray();
        if (count == 1) {
            dataJa.add((Object)text);
        } else {
            for (int a = 0; a < count; ++a) {
                int p1 = text.indexOf("end");
                dataJa.add((Object)text.substring(0, p1 + 3));
                text = text.substring(p1 + 3, text.length());
            }
        }
        return dataJa;
    }
}

