/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.env.input.server;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.huimv.env.input.entity.Chengzhong;
import com.huimv.env.input.service.IChengzhongService;
import com.huimv.env.input.utils.ModBusUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ChannelHandler.Sharable
@Component
public class EnvInputServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(EnvInputServerHandler.class);
    private StringBuilder askTextSb = null;
    @Autowired
    private IChengzhongService chengzhongService;

    public void appendClientAsk(String text) {
        if (this.askTextSb == null) {
            this.askTextSb = new StringBuilder();
        }
        this.askTextSb.append(text);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Channel channel = ctx.channel();
        ByteBuf byteBuf = (ByteBuf)msg;
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        String str = ModBusUtils.bytes2HexString((byte[])bytes);
        this.saveWeight(str);
        System.out.println("\u6536\u5230\u7684\u6570\u636e\uff1a" + str);
        Thread.sleep(10000L);
        channel.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])ModBusUtils.hexStr2Bytes((String)"01 42 3F 02 0D")));
        super.channelRead(ctx, msg);
    }

    private void saveWeight(String str) {
        try {
            if (null != str && str.split(" ").length > 7) {
                String[] s = str.split(" ");
                String macAddr = s[0] + s[1] + s[2] + s[3] + s[4] + s[5];
                Integer i = this.countWeight(s);
                Chengzhong chengzhong = new Chengzhong();
                chengzhong.setCreatTime(new Date());
                chengzhong.setMacAddr(macAddr);
                chengzhong.setWeight(i);
                Chengzhong one = (Chengzhong)this.chengzhongService.getOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().orderByDesc((Object)"id")).eq((Object)"mac_addr", (Object)macAddr)).last("limit 1"));
                int num = i;
                if (ObjectUtil.isNotEmpty((Object)one)) {
                    num = i - one.getWeight();
                }
                System.out.println(i);
                chengzhong.setNum(Integer.valueOf(num));
                this.chengzhongService.save((Object)chengzhong);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private Integer countWeight(String[] s) {
        int count = 48;
        return Integer.parseInt(s[8], 16) - count + (Integer.parseInt(s[9], 16) - count) * 16 + (Integer.parseInt(s[10], 16) - count) * 256 + (Integer.parseInt(s[11], 16) - count) * 4096 + (Integer.parseInt(s[12], 16) - count) * 6556;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause.getMessage().indexOf("Connection reset") != -1) {
            log.info("\u76f8\u5173\u91c7\u96c6\u5668\u8bbe\u5907\u6b63\u5728\u91cd\u542f:" + cause.toString());
        }
        ctx.close();
    }

    private void handleClientAskCmd(String clientAskText, ChannelHandlerContext ctx) throws ParseException, IOException {
        clientAskText = clientAskText.replaceAll("\r", "").replaceAll("\n", "");
        JSONArray askJa = this.parseAskCmdPackage(clientAskText);
        for (int a = 0; a < askJa.size(); ++a) {
            String askText = askJa.getString(a);
            this.askCmdActuator(askText, ctx);
        }
    }

    private void askCmdActuator(String askText, ChannelHandlerContext ctx) throws ParseException, IOException {
        System.out.println("======>\u63a5\u6536\u8bbe\u5907\u8bf7\u6c42:" + askText);
        String[] dataArray = askText.split("\\+");
        String cmdHeader = dataArray[0];
        if (!cmdHeader.trim().equalsIgnoreCase("hm")) {
            log.info("\u5f53\u524d\u547d\u4ee4\u662f\u975ehm\u547d\u4ee4[" + askText + "]");
            return;
        }
        String idCode = dataArray[1];
        String cmd = dataArray[2];
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("askText", askText);
        switch (cmd) {
            case "1": {
                this.getDeviceCode(askText, idCode, ctx);
                break;
            }
            case "2": {
                this.getServerTime(askText, idCode, ctx);
                break;
            }
            default: {
                System.out.println("==>\u672a\u77e5\u547d\u4ee4");
                log.error(">>\u5f53\u524d\u6570\u636e\u4e3a\u975e\u6cd5\u6570\u636e-\u672a\u77e5\u547d\u4ee4>>" + askText);
            }
        }
    }

    private void getServerTime(String askText, String deviceCode, ChannelHandlerContext ctx) throws ParseException {
        System.out.println("==>\u65f6\u95f4\u540c\u6b65\u8bf7\u6c42:" + askText);
        String answerText = "hm+2++0+4+end";
        this.answerCmd(answerText, ctx);
    }

    private void getDeviceCode(String askText, String idCode, ChannelHandlerContext ctx) {
        System.out.println("==>\u83b7\u53d6\u8fdc\u7a0b\u8bbe\u5907\u7f16\u7801\u8bf7\u6c42:" + askText.trim());
    }

    public void answerCmd(String answerText, ChannelHandlerContext ctx) {
        ctx.writeAndFlush((Object)Unpooled.copiedBuffer((byte[])answerText.getBytes()));
    }

    public boolean checkValidEarmark(String earmark) {
        return earmark.trim().equalsIgnoreCase("ffffffffffffffff") || earmark.trim().equalsIgnoreCase("0000000000000000");
    }

    public JSONArray parseAskCmdPackage(String text) {
        String key = "end";
        Pattern pattern = Pattern.compile(key);
        Matcher matcher = pattern.matcher(text);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        JSONArray dataJa = new JSONArray();
        if (count == 1) {
            dataJa.add((Object)text);
        } else {
            for (int a = 0; a < count; ++a) {
                int p1 = text.indexOf("end");
                dataJa.add((Object)text.substring(0, p1 + 3));
                text = text.substring(p1 + 3, text.length());
            }
        }
        return dataJa;
    }
}

