/*
 * Decompiled with CFR 0.152.
 */
package com.huimv.socketservice.result;

import com.huimv.socketservice.result.R;
import com.huimv.socketservice.result.RRException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class RRExceptionHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ExceptionHandler(value={RRException.class})
    public R handleRRException(RRException e) {
        R r = new R();
        r.put("code", (Object)e.getCode());
        r.put("msg", (Object)e.getMessage());
        this.logger.error(e.getMsg(), (Throwable)e);
        return r;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public R handlerNoFoundException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((int)404, (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public R handleDuplicateKeyException(DuplicateKeyException e) {
        this.logger.error(e.toString());
        String message = e.getCause().getMessage();
        String[] s = message.split(" ");
        return R.error((int)600, (String)(s[2].replace("'", "") + " \u5df2\u7ecf\u5b58\u5728!"));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public R handleMethodArgumentNotValidException(MethodArgumentNotValidException ex) {
        this.logger.error(ex.getMessage(), (Throwable)ex);
        StringBuilder sb = new StringBuilder();
        for (ObjectError error : ex.getBindingResult().getAllErrors()) {
            if (!(error instanceof FieldError)) continue;
            FieldError e = (FieldError)error;
            sb.append(e.getField()).append(e.getDefaultMessage()).append(" ");
        }
        return R.error((int)1001, (String)sb.toString());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public R handMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((int)1001, (String)e.getMessage());
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public R handDataIntegrityViolationException(DataIntegrityViolationException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((int)1001, (String)e.getCause().getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public R handHttpRequestMethodNotSupportedException(HttpRequestMethodNotSupportedException e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error((int)1001, (String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public R handleException(Exception e) {
        this.logger.error(e.getMessage(), (Throwable)e);
        return R.error();
    }
}

