/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.util;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.reactive.ReactiveFlowKt;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.Single;

public final class ReactiveWrapperConverters {
    private static final List<ReactiveTypeWrapper<?>> REACTIVE_WRAPPERS = new ArrayList();
    private static final GenericConversionService GENERIC_CONVERSION_SERVICE = new GenericConversionService();

    private static ConversionService registerConvertersIn(ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null!");
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            conversionService.addConverter(PublisherToMonoConverter.INSTANCE);
            conversionService.addConverter(PublisherToFluxConverter.INSTANCE);
            if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.KOTLIN_COROUTINES)) {
                conversionService.addConverter(PublisherToFlowConverter.INSTANCE);
            }
            if (RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null) {
                conversionService.addConverterFactory(ReactiveAdapterConverterFactory.INSTANCE);
            }
        }
        return conversionService;
    }

    public static boolean supports(Class<?> type) {
        return RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null && RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(type) != null;
    }

    @Nullable
    public static <T> T toWrapper(Object reactiveObject, Class<? extends T> targetWrapperType) {
        Assert.notNull(reactiveObject, "Reactive source object must not be null!");
        Assert.notNull(targetWrapperType, "Reactive target type must not be null!");
        if (targetWrapperType.isAssignableFrom(reactiveObject.getClass())) {
            return (T)reactiveObject;
        }
        return GENERIC_CONVERSION_SERVICE.convert(reactiveObject, targetWrapperType);
    }

    public static <T> T map(Object reactiveObject, Function<Object, Object> converter) {
        Assert.notNull(reactiveObject, "Reactive source object must not be null!");
        Assert.notNull(converter, "Converter must not be null!");
        return (T)REACTIVE_WRAPPERS.stream().filter(it -> ClassUtils.isAssignable(it.getWrapperClass(), reactiveObject.getClass())).findFirst().map(it -> it.map(reactiveObject, converter)).orElseThrow(() -> new IllegalStateException(String.format("Cannot apply converter to %s", reactiveObject)));
    }

    public static boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        Assert.notNull(sourceType, "Source type must not be null!");
        Assert.notNull(targetType, "Target type must not be null!");
        return GENERIC_CONVERSION_SERVICE.canConvert(sourceType, targetType);
    }

    @Generated
    private ReactiveWrapperConverters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA1)) {
            REACTIVE_WRAPPERS.add(RxJava1SingleWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava1ObservableWrapper.INSTANCE);
        }
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.RXJAVA2)) {
            REACTIVE_WRAPPERS.add(RxJava2SingleWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2MaybeWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2ObservableWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(RxJava2FlowableWrapper.INSTANCE);
        }
        if (ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            REACTIVE_WRAPPERS.add(FluxWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(MonoWrapper.INSTANCE);
            REACTIVE_WRAPPERS.add(PublisherWrapper.INSTANCE);
        }
        ReactiveWrapperConverters.registerConvertersIn(GENERIC_CONVERSION_SERVICE);
    }

    static class RegistryHolder {
        @Nullable
        static final ReactiveAdapterRegistry REACTIVE_ADAPTER_REGISTRY = ReactiveWrappers.isAvailable(ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR) ? new ReactiveAdapterRegistry() : null;

        RegistryHolder() {
        }
    }

    private static enum ReactiveAdapterConverterFactory implements ConverterFactory<Object, Object>,
    ConditionalConverter
    {
        INSTANCE;


        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return this.isSupported(sourceType) || this.isSupported(targetType);
        }

        private boolean isSupported(TypeDescriptor typeDescriptor) {
            return RegistryHolder.REACTIVE_ADAPTER_REGISTRY != null && RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(typeDescriptor.getType()) != null;
        }

        @Override
        public <T> Converter<Object, T> getConverter(Class<T> targetType) {
            return source -> {
                Publisher publisher = source instanceof Publisher ? (Publisher)source : RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(Publisher.class, source).toPublisher(source);
                ReactiveAdapter adapter = RegistryHolder.REACTIVE_ADAPTER_REGISTRY.getAdapter(targetType);
                return adapter.fromPublisher(publisher);
            };
        }
    }

    private static enum PublisherToFlowConverter implements Converter<Publisher<?>, Flow<?>>
    {
        INSTANCE;


        @Override
        @Nonnull
        public Flow<?> convert(Publisher<?> source) {
            return ReactiveFlowKt.asFlow(source);
        }
    }

    private static enum PublisherToMonoConverter implements Converter<Publisher<?>, Mono<?>>
    {
        INSTANCE;


        @Override
        @Nonnull
        public Mono<?> convert(Publisher<?> source) {
            return Mono.from(source);
        }
    }

    private static enum PublisherToFluxConverter implements Converter<Publisher<?>, Flux<?>>
    {
        INSTANCE;


        @Override
        @Nonnull
        public Flux<?> convert(Publisher<?> source) {
            return Flux.from(source);
        }
    }

    private static enum RxJava2FlowableWrapper implements ReactiveTypeWrapper<Flowable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flowable<?>> getWrapperClass() {
            return Flowable.class;
        }

        public Flowable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flowable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2ObservableWrapper implements ReactiveTypeWrapper<io.reactivex.Observable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super io.reactivex.Observable<?>> getWrapperClass() {
            return io.reactivex.Observable.class;
        }

        public io.reactivex.Observable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((io.reactivex.Observable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2MaybeWrapper implements ReactiveTypeWrapper<Maybe<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Maybe<?>> getWrapperClass() {
            return Maybe.class;
        }

        public Maybe<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Maybe)wrapper).map(function::apply);
        }
    }

    private static enum RxJava2SingleWrapper implements ReactiveTypeWrapper<io.reactivex.Single<?>>
    {
        INSTANCE;


        @Override
        public Class<? super io.reactivex.Single<?>> getWrapperClass() {
            return io.reactivex.Single.class;
        }

        public io.reactivex.Single<?> map(Object wrapper, Function<Object, Object> function) {
            return ((io.reactivex.Single)wrapper).map(function::apply);
        }
    }

    private static enum RxJava1ObservableWrapper implements ReactiveTypeWrapper<Observable<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Observable<?>> getWrapperClass() {
            return Observable.class;
        }

        public Observable<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Observable)wrapper).map(function::apply);
        }
    }

    private static enum RxJava1SingleWrapper implements ReactiveTypeWrapper<Single<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Single<?>> getWrapperClass() {
            return Single.class;
        }

        public Single<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Single)wrapper).map(function::apply);
        }
    }

    private static enum PublisherWrapper implements ReactiveTypeWrapper<Publisher<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Publisher<?>> getWrapperClass() {
            return Publisher.class;
        }

        public Publisher<?> map(Object wrapper, Function<Object, Object> function) {
            if (wrapper instanceof Mono) {
                return MonoWrapper.INSTANCE.map(wrapper, function);
            }
            if (wrapper instanceof Flux) {
                return FluxWrapper.INSTANCE.map(wrapper, function);
            }
            return FluxWrapper.INSTANCE.map((Object)Flux.from((Publisher)((Publisher)wrapper)), function);
        }
    }

    private static enum FluxWrapper implements ReactiveTypeWrapper<Flux<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Flux<?>> getWrapperClass() {
            return Flux.class;
        }

        public Flux<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Flux)wrapper).map(function::apply);
        }
    }

    private static enum MonoWrapper implements ReactiveTypeWrapper<Mono<?>>
    {
        INSTANCE;


        @Override
        public Class<? super Mono<?>> getWrapperClass() {
            return Mono.class;
        }

        public Mono<?> map(Object wrapper, Function<Object, Object> function) {
            return ((Mono)wrapper).map(function::apply);
        }
    }

    private static interface ReactiveTypeWrapper<T> {
        public Class<? super T> getWrapperClass();

        public Object map(Object var1, Function<Object, Object> var2);
    }
}

