/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.util.ProxyUtils;
import org.springframework.transaction.annotation.Ejb3TransactionAnnotationParser;
import org.springframework.transaction.annotation.JtaTransactionAnnotationParser;
import org.springframework.transaction.annotation.SpringTransactionAnnotationParser;
import org.springframework.transaction.annotation.TransactionAnnotationParser;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

class TransactionalRepositoryProxyPostProcessor
implements RepositoryProxyPostProcessor {
    private final BeanFactory beanFactory;
    private final String transactionManagerName;
    private final boolean enableDefaultTransactions;

    public TransactionalRepositoryProxyPostProcessor(ListableBeanFactory beanFactory, String transactionManagerName, boolean enableDefaultTransaction) {
        Assert.notNull((Object)beanFactory, "BeanFactory must not be null!");
        Assert.notNull((Object)transactionManagerName, "TransactionManagerName must not be null!");
        this.beanFactory = beanFactory;
        this.transactionManagerName = transactionManagerName;
        this.enableDefaultTransactions = enableDefaultTransaction;
    }

    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        CustomAnnotationTransactionAttributeSource transactionAttributeSource = new CustomAnnotationTransactionAttributeSource();
        transactionAttributeSource.setRepositoryInformation(repositoryInformation);
        transactionAttributeSource.setEnableDefaultTransactions(this.enableDefaultTransactions);
        TransactionInterceptor transactionInterceptor = new TransactionInterceptor(null, (TransactionAttributeSource)transactionAttributeSource);
        transactionInterceptor.setTransactionManagerBeanName(this.transactionManagerName);
        transactionInterceptor.setBeanFactory(this.beanFactory);
        transactionInterceptor.afterPropertiesSet();
        factory.addAdvice(transactionInterceptor);
    }

    static abstract class AbstractFallbackTransactionAttributeSource
    implements TransactionAttributeSource {
        private static final TransactionAttribute NULL_TRANSACTION_ATTRIBUTE = new DefaultTransactionAttribute();
        protected final Logger logger = LoggerFactory.getLogger(this.getClass());
        final Map<Object, TransactionAttribute> attributeCache = new ConcurrentHashMap<Object, TransactionAttribute>();
        private RepositoryInformation repositoryInformation;
        private boolean enableDefaultTransactions = true;

        AbstractFallbackTransactionAttributeSource() {
        }

        public void setRepositoryInformation(RepositoryInformation repositoryInformation) {
            this.repositoryInformation = repositoryInformation;
        }

        public void setEnableDefaultTransactions(boolean enableDefaultTransactions) {
            this.enableDefaultTransactions = enableDefaultTransactions;
        }

        @Override
        public TransactionAttribute getTransactionAttribute(Method method, Class<?> targetClass) {
            Object cacheKey = this.getCacheKey(method, targetClass);
            TransactionAttribute cached = this.attributeCache.get(cacheKey);
            if (cached != null) {
                if (cached == NULL_TRANSACTION_ATTRIBUTE) {
                    return null;
                }
                return cached;
            }
            TransactionAttribute txAtt = this.computeTransactionAttribute(method, targetClass);
            if (txAtt == null) {
                this.attributeCache.put(cacheKey, NULL_TRANSACTION_ATTRIBUTE);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Adding transactional method '" + method.getName() + "' with attribute: " + txAtt);
                }
                this.attributeCache.put(cacheKey, txAtt);
            }
            return txAtt;
        }

        protected Object getCacheKey(Method method, Class<?> targetClass) {
            return new DefaultCacheKey(method, targetClass);
        }

        private TransactionAttribute computeTransactionAttribute(Method method, Class<?> targetClass) {
            if (this.allowPublicMethodsOnly() && !Modifier.isPublic(method.getModifiers())) {
                return null;
            }
            Class<?> userClass = ProxyUtils.getUserClass(targetClass);
            Method specificMethod = ClassUtils.getMostSpecificMethod(method, userClass);
            specificMethod = BridgeMethodResolver.findBridgedMethod(specificMethod);
            TransactionAttribute txAtt = null;
            if (specificMethod != method) {
                txAtt = this.findTransactionAttribute(method);
                if (txAtt != null) {
                    return txAtt;
                }
                txAtt = this.findTransactionAttribute(method.getDeclaringClass());
                if (txAtt != null || !this.enableDefaultTransactions) {
                    return txAtt;
                }
            }
            if ((txAtt = this.findTransactionAttribute(specificMethod)) != null) {
                return txAtt;
            }
            txAtt = this.findTransactionAttribute(specificMethod.getDeclaringClass());
            if (txAtt != null) {
                return txAtt;
            }
            if (!this.enableDefaultTransactions) {
                return null;
            }
            Method targetClassMethod = this.repositoryInformation.getTargetClassMethod(method);
            if (targetClassMethod.equals(method)) {
                return null;
            }
            txAtt = this.findTransactionAttribute(targetClassMethod);
            if (txAtt != null) {
                return txAtt;
            }
            txAtt = this.findTransactionAttribute(targetClassMethod.getDeclaringClass());
            if (txAtt != null) {
                return txAtt;
            }
            return null;
        }

        protected abstract TransactionAttribute findTransactionAttribute(Method var1);

        protected abstract TransactionAttribute findTransactionAttribute(Class<?> var1);

        protected boolean allowPublicMethodsOnly() {
            return false;
        }

        private static class DefaultCacheKey {
            private final Method method;
            private final Class<?> targetClass;

            public DefaultCacheKey(Method method, Class<?> targetClass) {
                this.method = method;
                this.targetClass = targetClass;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DefaultCacheKey)) {
                    return false;
                }
                DefaultCacheKey otherKey = (DefaultCacheKey)other;
                return this.method.equals(otherKey.method) && ObjectUtils.nullSafeEquals(this.targetClass, otherKey.targetClass);
            }

            public int hashCode() {
                return this.method.hashCode() * 29 + (this.targetClass != null ? this.targetClass.hashCode() : 0);
            }
        }
    }

    static class CustomAnnotationTransactionAttributeSource
    extends AbstractFallbackTransactionAttributeSource
    implements Serializable {
        private static final boolean jta12Present = ClassUtils.isPresent("javax.transaction.Transactional", CustomAnnotationTransactionAttributeSource.class.getClassLoader());
        private static final boolean ejb3Present = ClassUtils.isPresent("javax.ejb.TransactionAttribute", CustomAnnotationTransactionAttributeSource.class.getClassLoader());
        private final boolean publicMethodsOnly;
        private final Set<TransactionAnnotationParser> annotationParsers;

        public CustomAnnotationTransactionAttributeSource() {
            this(true);
        }

        public CustomAnnotationTransactionAttributeSource(boolean publicMethodsOnly) {
            this.publicMethodsOnly = publicMethodsOnly;
            this.annotationParsers = new LinkedHashSet<TransactionAnnotationParser>(2);
            this.annotationParsers.add(new SpringTransactionAnnotationParser());
            if (jta12Present) {
                this.annotationParsers.add(new JtaTransactionAnnotationParser());
            }
            if (ejb3Present) {
                this.annotationParsers.add(new Ejb3TransactionAnnotationParser());
            }
        }

        public CustomAnnotationTransactionAttributeSource(TransactionAnnotationParser annotationParser) {
            this.publicMethodsOnly = true;
            Assert.notNull((Object)annotationParser, "TransactionAnnotationParser must not be null");
            this.annotationParsers = Collections.singleton(annotationParser);
        }

        public CustomAnnotationTransactionAttributeSource(TransactionAnnotationParser ... annotationParsers) {
            this.publicMethodsOnly = true;
            Assert.notEmpty((Object[])annotationParsers, "At least one TransactionAnnotationParser needs to be specified");
            LinkedHashSet<TransactionAnnotationParser> parsers = new LinkedHashSet<TransactionAnnotationParser>(annotationParsers.length);
            Collections.addAll(parsers, annotationParsers);
            this.annotationParsers = parsers;
        }

        public CustomAnnotationTransactionAttributeSource(Set<TransactionAnnotationParser> annotationParsers) {
            this.publicMethodsOnly = true;
            Assert.notEmpty(annotationParsers, "At least one TransactionAnnotationParser needs to be specified");
            this.annotationParsers = annotationParsers;
        }

        @Override
        protected TransactionAttribute findTransactionAttribute(Method method) {
            return this.determineTransactionAttribute(method);
        }

        @Override
        protected TransactionAttribute findTransactionAttribute(Class<?> clazz) {
            return this.determineTransactionAttribute(clazz);
        }

        protected TransactionAttribute determineTransactionAttribute(AnnotatedElement ae) {
            for (TransactionAnnotationParser annotationParser : this.annotationParsers) {
                TransactionAttribute attr = annotationParser.parseTransactionAnnotation(ae);
                if (attr == null) continue;
                return attr;
            }
            return null;
        }

        @Override
        protected boolean allowPublicMethodsOnly() {
            return this.publicMethodsOnly;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomAnnotationTransactionAttributeSource)) {
                return false;
            }
            CustomAnnotationTransactionAttributeSource otherTas = (CustomAnnotationTransactionAttributeSource)other;
            return this.annotationParsers.equals(otherTas.annotationParsers) && this.publicMethodsOnly == otherTas.publicMethodsOnly;
        }

        public int hashCode() {
            return this.annotationParsers.hashCode();
        }
    }
}

