/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.LockModeType;
import javax.persistence.QueryHint;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Lock;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultJpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaEntityGraph;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributeSource;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JpaQueryMethod
extends QueryMethod {
    private static final Set<Class<?>> NATIVE_ARRAY_TYPES;
    private static final StoredProcedureAttributeSource storedProcedureAttributeSource;
    private final QueryExtractor extractor;
    private final Method method;
    @Nullable
    private StoredProcedureAttributes storedProcedureAttributes;
    private final Lazy<LockModeType> lockModeType;
    private final Lazy<QueryHints> queryHints;
    private final Lazy<JpaEntityGraph> jpaEntityGraph;
    private final Lazy<Modifying> modifying;
    private final Lazy<Boolean> isNativeQuery;
    private final Lazy<Boolean> isCollectionQuery;
    private final Lazy<Boolean> isProcedureQuery;
    private final Lazy<JpaEntityMetadata<?>> entityMetadata;

    protected JpaQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, QueryExtractor extractor) {
        super(method, metadata, factory);
        Assert.notNull((Object)method, "Method must not be null!");
        Assert.notNull((Object)extractor, "Query extractor must not be null!");
        this.method = method;
        this.extractor = extractor;
        this.lockModeType = Lazy.of(() -> Optional.ofNullable(AnnotatedElementUtils.findMergedAnnotation(method, Lock.class)).map(AnnotationUtils::getValue).orElse(null));
        this.queryHints = Lazy.of(() -> AnnotatedElementUtils.findMergedAnnotation(method, QueryHints.class));
        this.modifying = Lazy.of(() -> AnnotatedElementUtils.findMergedAnnotation(method, Modifying.class));
        this.jpaEntityGraph = Lazy.of(() -> {
            EntityGraph entityGraph = AnnotatedElementUtils.findMergedAnnotation(method, EntityGraph.class);
            if (entityGraph == null) {
                return null;
            }
            return new JpaEntityGraph(entityGraph, this.getNamedQueryName());
        });
        this.isNativeQuery = Lazy.of(() -> this.getAnnotationValue("nativeQuery", Boolean.class));
        this.isCollectionQuery = Lazy.of(() -> super.isCollectionQuery() && !NATIVE_ARRAY_TYPES.contains(method.getReturnType()));
        this.isProcedureQuery = Lazy.of(() -> AnnotationUtils.findAnnotation(method, Procedure.class) != null);
        this.entityMetadata = Lazy.of(() -> new DefaultJpaEntityMetadata(this.getDomainClass()));
        Assert.isTrue(!this.isModifyingQuery() || !this.getParameters().hasSpecialParameter(), String.format("Modifying method must not contain %s!", Parameters.TYPES));
        this.assertParameterNamesInAnnotatedQuery();
    }

    private void assertParameterNamesInAnnotatedQuery() {
        String annotatedQuery = this.getAnnotatedQuery();
        if (!DeclaredQuery.of(annotatedQuery).hasNamedParameter()) {
            return;
        }
        for (Parameter parameter : this.getParameters()) {
            if (!parameter.isNamedParameter() || !StringUtils.isEmpty(annotatedQuery) && (annotatedQuery.contains(String.format(":%s", parameter.getName().get())) || annotatedQuery.contains(String.format("#%s", parameter.getName().get())))) continue;
            throw new IllegalStateException(String.format("Using named parameters for method %s but parameter '%s' not found in annotated query '%s'!", this.method, parameter.getName(), annotatedQuery));
        }
    }

    public JpaEntityMetadata<?> getEntityInformation() {
        return this.entityMetadata.get();
    }

    @Override
    public boolean isModifyingQuery() {
        return this.modifying.getNullable() != null;
    }

    List<QueryHint> getHints() {
        QueryHints hints = this.queryHints.getNullable();
        if (hints != null) {
            return Arrays.asList(hints.value());
        }
        return Collections.emptyList();
    }

    @Nullable
    LockModeType getLockModeType() {
        return this.lockModeType.getNullable();
    }

    @Nullable
    JpaEntityGraph getEntityGraph() {
        return this.jpaEntityGraph.getNullable();
    }

    boolean applyHintsToCountQuery() {
        QueryHints hints = this.queryHints.getNullable();
        return hints != null ? hints.forCounting() : false;
    }

    QueryExtractor getQueryExtractor() {
        return this.extractor;
    }

    Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    @Nullable
    String getAnnotatedQuery() {
        String query2 = this.getAnnotationValue("value", String.class);
        return StringUtils.hasText(query2) ? query2 : null;
    }

    String getRequiredAnnotatedQuery() throws IllegalStateException {
        String query2 = this.getAnnotatedQuery();
        if (query2 != null) {
            return query2;
        }
        throw new IllegalStateException(String.format("No annotated query found for query method %s!", this.getName()));
    }

    @Nullable
    String getCountQuery() {
        String countQuery = this.getAnnotationValue("countQuery", String.class);
        return StringUtils.hasText(countQuery) ? countQuery : null;
    }

    @Nullable
    String getCountQueryProjection() {
        String countProjection = this.getAnnotationValue("countProjection", String.class);
        return StringUtils.hasText(countProjection) ? countProjection : null;
    }

    boolean isNativeQuery() {
        return this.isNativeQuery.get();
    }

    @Override
    public String getNamedQueryName() {
        String annotatedName = this.getAnnotationValue("name", String.class);
        return StringUtils.hasText(annotatedName) ? annotatedName : super.getNamedQueryName();
    }

    String getNamedCountQueryName() {
        String annotatedName = this.getAnnotationValue("countName", String.class);
        return StringUtils.hasText(annotatedName) ? annotatedName : this.getNamedQueryName() + ".count";
    }

    boolean getFlushAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("flushAutomatically", Modifying.class, Boolean.class);
    }

    boolean getClearAutomatically() {
        return this.getMergedOrDefaultAnnotationValue("clearAutomatically", Modifying.class, Boolean.class);
    }

    private <T> T getAnnotationValue(String attribute, Class<T> type) {
        return this.getMergedOrDefaultAnnotationValue(attribute, Query.class, type);
    }

    private <T> T getMergedOrDefaultAnnotationValue(String attribute, Class annotationType, Class<T> targetType) {
        Object annotation = AnnotatedElementUtils.findMergedAnnotation(this.method, annotationType);
        if (annotation == null) {
            return targetType.cast(AnnotationUtils.getDefaultValue(annotationType, attribute));
        }
        return targetType.cast(AnnotationUtils.getValue(annotation, attribute));
    }

    protected JpaParameters createParameters(Method method) {
        return new JpaParameters(method);
    }

    public JpaParameters getParameters() {
        return (JpaParameters)super.getParameters();
    }

    @Override
    public boolean isCollectionQuery() {
        return this.isCollectionQuery.get();
    }

    public boolean isProcedureQuery() {
        return this.isProcedureQuery.get();
    }

    StoredProcedureAttributes getProcedureAttributes() {
        if (this.storedProcedureAttributes == null) {
            this.storedProcedureAttributes = storedProcedureAttributeSource.createFrom(this.method, (JpaEntityMetadata<?>)this.getEntityInformation());
        }
        return this.storedProcedureAttributes;
    }

    static {
        storedProcedureAttributeSource = StoredProcedureAttributeSource.INSTANCE;
        HashSet<Class> types = new HashSet<Class>();
        types.add(byte[].class);
        types.add(Byte[].class);
        types.add(char[].class);
        types.add(Character[].class);
        NATIVE_ARRAY_TYPES = Collections.unmodifiableSet(types);
    }
}

