/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.regex.Pattern;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaEntityMetadata;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

class ExpressionBasedStringQuery
extends StringQuery {
    private static final String EXPRESSION_PARAMETER = "?#{";
    private static final String QUOTED_EXPRESSION_PARAMETER = "?__HASH__{";
    private static final Pattern EXPRESSION_PARAMETER_QUOTING = Pattern.compile(Pattern.quote("?#{"));
    private static final Pattern EXPRESSION_PARAMETER_UNQUOTING = Pattern.compile(Pattern.quote("?__HASH__{"));
    private static final String ENTITY_NAME = "entityName";
    private static final String ENTITY_NAME_VARIABLE = "#entityName";
    private static final String ENTITY_NAME_VARIABLE_EXPRESSION = "#{#entityName}";

    public ExpressionBasedStringQuery(String query2, JpaEntityMetadata<?> metadata, SpelExpressionParser parser) {
        super(ExpressionBasedStringQuery.renderQueryIfExpressionOrReturnQuery(query2, metadata, parser));
    }

    static ExpressionBasedStringQuery from(DeclaredQuery query2, JpaEntityMetadata metadata, SpelExpressionParser parser) {
        return new ExpressionBasedStringQuery(query2.getQueryString(), metadata, parser);
    }

    private static String renderQueryIfExpressionOrReturnQuery(String query2, JpaEntityMetadata<?> metadata, SpelExpressionParser parser) {
        Assert.notNull((Object)query2, "query must not be null!");
        Assert.notNull(metadata, "metadata must not be null!");
        Assert.notNull((Object)parser, "parser must not be null!");
        if (!ExpressionBasedStringQuery.containsExpression(query2)) {
            return query2;
        }
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        evalContext.setVariable(ENTITY_NAME, metadata.getEntityName());
        query2 = ExpressionBasedStringQuery.potentiallyQuoteExpressionsParameter(query2);
        Expression expr = parser.parseExpression(query2, ParserContext.TEMPLATE_EXPRESSION);
        String result = expr.getValue((EvaluationContext)evalContext, String.class);
        if (result == null) {
            return query2;
        }
        return ExpressionBasedStringQuery.potentiallyUnquoteParameterExpressions(result);
    }

    private static String potentiallyUnquoteParameterExpressions(String result) {
        return EXPRESSION_PARAMETER_UNQUOTING.matcher(result).replaceAll(EXPRESSION_PARAMETER);
    }

    private static String potentiallyQuoteExpressionsParameter(String query2) {
        return EXPRESSION_PARAMETER_QUOTING.matcher(query2).replaceAll(QUOTED_EXPRESSION_PARAMETER);
    }

    private static boolean containsExpression(String query2) {
        return query2.contains(ENTITY_NAME_VARIABLE_EXPRESSION);
    }
}

