/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import javax.persistence.EntityManager;
import javax.persistence.metamodel.Metamodel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class JpaClassUtils {
    private JpaClassUtils() {
    }

    public static boolean isEntityManagerOfType(EntityManager em, String type) {
        EntityManager entityManagerToUse = em;
        Object delegate = em.getDelegate();
        if (delegate instanceof EntityManager) {
            entityManagerToUse = (EntityManager)delegate;
        }
        return JpaClassUtils.isOfType(entityManagerToUse, type, entityManagerToUse.getClass().getClassLoader());
    }

    public static boolean isMetamodelOfType(Metamodel metamodel, String type) {
        return JpaClassUtils.isOfType(metamodel, type, metamodel.getClass().getClassLoader());
    }

    private static boolean isOfType(Object source, String typeName, @Nullable ClassLoader classLoader) {
        Assert.notNull(source, "Source instance must not be null!");
        Assert.hasText(typeName, "Target type name must not be null or empty!");
        try {
            return ClassUtils.forName(typeName, classLoader).isInstance(source);
        }
        catch (Exception e) {
            return false;
        }
    }
}

