/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.Nullable;

class SpecificationComposition {
    SpecificationComposition() {
    }

    @Nullable
    static <T> Specification<T> composed(@Nullable Specification<T> lhs, @Nullable Specification<T> rhs, Combiner combiner) {
        return (root, query2, builder) -> {
            Predicate otherPredicate = SpecificationComposition.toPredicate(lhs, root, query2, builder);
            Predicate thisPredicate = SpecificationComposition.toPredicate(rhs, root, query2, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    private static <T> Predicate toPredicate(Specification<T> specification, Root<T> root, CriteriaQuery<?> query2, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, query2, builder);
    }

    static interface Combiner
    extends Serializable {
        public Predicate combine(CriteriaBuilder var1, @Nullable Predicate var2, @Nullable Predicate var3);
    }
}

