/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.component;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Property;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.Setter;
import org.hibernate.tuple.Instantiator;
import org.hibernate.tuple.component.ComponentTuplizer;

public abstract class AbstractComponentTuplizer
implements ComponentTuplizer {
    protected final Getter[] getters;
    protected final Setter[] setters;
    protected final int propertySpan;
    protected final Instantiator instantiator;
    protected final boolean hasCustomAccessors;

    protected abstract Instantiator buildInstantiator(Component var1);

    protected abstract Getter buildGetter(Component var1, Property var2);

    protected abstract Setter buildSetter(Component var1, Property var2);

    protected AbstractComponentTuplizer(Component component) {
        this.setComponentClass(component);
        this.propertySpan = component.getPropertySpan();
        this.getters = new Getter[this.propertySpan];
        this.setters = new Setter[this.propertySpan];
        Iterator iter = component.getPropertyIterator();
        boolean foundCustomAccessor = false;
        int i2 = 0;
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            this.getters[i2] = this.buildGetter(component, prop);
            this.setters[i2] = this.buildSetter(component, prop);
            if (!prop.isBasicPropertyAccessor()) {
                foundCustomAccessor = true;
            }
            ++i2;
        }
        this.hasCustomAccessors = foundCustomAccessor;
        this.instantiator = this.buildInstantiator(component);
    }

    @Override
    public Object getPropertyValue(Object component, int i2) throws HibernateException {
        return this.getters[i2].get(component);
    }

    @Override
    public Object[] getPropertyValues(Object component) throws HibernateException {
        Object[] values = new Object[this.propertySpan];
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            values[i2] = this.getPropertyValue(component, i2);
        }
        return values;
    }

    @Override
    public boolean isInstance(Object object) {
        return this.instantiator.isInstance(object);
    }

    @Override
    public void setPropertyValues(Object component, Object[] values) throws HibernateException {
        for (int i2 = 0; i2 < this.propertySpan; ++i2) {
            this.setters[i2].set(component, values[i2], null);
        }
    }

    @Override
    public Object instantiate() throws HibernateException {
        return this.instantiator.instantiate();
    }

    @Override
    public Object getParent(Object component) {
        return null;
    }

    @Override
    public boolean hasParentProperty() {
        return false;
    }

    @Override
    public boolean isMethodOf(Method method) {
        return false;
    }

    @Override
    public void setParent(Object component, Object parent, SessionFactoryImplementor factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Getter getGetter(int i2) {
        return this.getters[i2];
    }

    protected void setComponentClass(Component component) {
    }
}

