/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.ParameterMetadata;
import org.hibernate.query.Query;
import org.hibernate.query.internal.AbstractProducedQuery;
import org.hibernate.query.internal.QueryParameterBindingsImpl;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.type.Type;

public class QueryImpl<R>
extends AbstractProducedQuery<R>
implements Query<R> {
    private final String queryString;
    private final QueryParameterBindingsImpl queryParameterBindings;

    public QueryImpl(SharedSessionContractImplementor producer, ParameterMetadata parameterMetadata, String queryString) {
        super(producer, parameterMetadata);
        this.queryString = queryString;
        this.queryParameterBindings = QueryParameterBindingsImpl.from(parameterMetadata, producer.getFactory(), producer.isQueryParametersValidationEnabled());
    }

    @Override
    protected QueryParameterBindings getQueryParameterBindings() {
        return this.queryParameterBindings;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    protected boolean isNativeQuery() {
        return false;
    }

    @Override
    public Type[] getReturnTypes() {
        return this.getProducer().getFactory().getReturnTypes(this.queryString);
    }

    @Override
    public String[] getReturnAliases() {
        return this.getProducer().getFactory().getReturnAliases(this.queryString);
    }

    @Override
    public Query setEntity(int position, Object val2) {
        return this.setParameter(position, val2, this.getProducer().getFactory().getTypeHelper().entity(this.resolveEntityName(val2)));
    }

    @Override
    public Query setEntity(String name, Object val2) {
        return this.setParameter(name, val2, this.getProducer().getFactory().getTypeHelper().entity(this.resolveEntityName(val2)));
    }
}

